/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.LexicalAnalyzer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class StopAnalyzer
extends LexicalAnalyzer {
    private List<String> stopwords;

    public StopAnalyzer(String name) {
        super(name);
    }

    public List<String> getStopwords() {
        return this.stopwords;
    }

    public StopAnalyzer setStopwords(List<String> stopwords) {
        this.stopwords = stopwords;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.StopAnalyzer");
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeArrayField("stopwords", this.stopwords, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static StopAnalyzer fromJson(JsonReader jsonReader) throws IOException {
        return (StopAnalyzer)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            List stopwords = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Azure.Search.StopAnalyzer".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.StopAnalyzer'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("stopwords".equals(fieldName)) {
                    stopwords = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                StopAnalyzer deserializedStopAnalyzer = new StopAnalyzer(name);
                deserializedStopAnalyzer.stopwords = stopwords;
                return deserializedStopAnalyzer;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }

    public StopAnalyzer setStopwords(String ... stopwords) {
        this.stopwords = stopwords == null ? null : Arrays.asList(stopwords);
        return this;
    }
}

