/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.SearchServiceCounters;
import com.azure.search.documents.indexes.models.SearchServiceLimits;
import java.io.IOException;
import java.util.ArrayList;

public final class SearchServiceStatistics
implements JsonSerializable<SearchServiceStatistics> {
    private final SearchServiceCounters counters;
    private final SearchServiceLimits limits;

    public SearchServiceStatistics(SearchServiceCounters counters, SearchServiceLimits limits) {
        this.counters = counters;
        this.limits = limits;
    }

    public SearchServiceCounters getCounters() {
        return this.counters;
    }

    public SearchServiceLimits getLimits() {
        return this.limits;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("counters", (JsonSerializable)this.counters);
        jsonWriter.writeJsonField("limits", (JsonSerializable)this.limits);
        return jsonWriter.writeEndObject();
    }

    public static SearchServiceStatistics fromJson(JsonReader jsonReader) throws IOException {
        return (SearchServiceStatistics)jsonReader.readObject(reader -> {
            boolean countersFound = false;
            SearchServiceCounters counters = null;
            boolean limitsFound = false;
            SearchServiceLimits limits = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("counters".equals(fieldName)) {
                    counters = SearchServiceCounters.fromJson(reader);
                    countersFound = true;
                    continue;
                }
                if ("limits".equals(fieldName)) {
                    limits = SearchServiceLimits.fromJson(reader);
                    limitsFound = true;
                    continue;
                }
                reader.skipChildren();
            }
            if (countersFound && limitsFound) {
                SearchServiceStatistics deserializedSearchServiceStatistics = new SearchServiceStatistics(counters, limits);
                return deserializedSearchServiceStatistics;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!countersFound) {
                missingProperties.add("counters");
            }
            if (!limitsFound) {
                missingProperties.add("limits");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

