/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class PatternCaptureTokenFilter
extends TokenFilter {
    private final List<String> patterns;
    private Boolean preserveOriginal;

    public PatternCaptureTokenFilter(String name, List<String> patterns) {
        super(name);
        this.patterns = patterns;
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    public Boolean isPreserveOriginal() {
        return this.preserveOriginal;
    }

    public PatternCaptureTokenFilter setPreserveOriginal(Boolean preserveOriginal) {
        this.preserveOriginal = preserveOriginal;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.PatternCaptureTokenFilter");
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeArrayField("patterns", this.patterns, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("preserveOriginal", this.preserveOriginal);
        return jsonWriter.writeEndObject();
    }

    public static PatternCaptureTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (PatternCaptureTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean patternsFound = false;
            List patterns = null;
            Boolean preserveOriginal = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Azure.Search.PatternCaptureTokenFilter".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.PatternCaptureTokenFilter'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("patterns".equals(fieldName)) {
                    patterns = reader.readArray(reader1 -> reader1.getString());
                    patternsFound = true;
                    continue;
                }
                if ("preserveOriginal".equals(fieldName)) {
                    preserveOriginal = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound && patternsFound) {
                PatternCaptureTokenFilter deserializedPatternCaptureTokenFilter = new PatternCaptureTokenFilter(name, patterns);
                deserializedPatternCaptureTokenFilter.preserveOriginal = preserveOriginal;
                return deserializedPatternCaptureTokenFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!patternsFound) {
                missingProperties.add("patterns");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

