/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.models.TokenFilter;
import java.io.IOException;
import java.util.ArrayList;

public final class LimitTokenFilter
extends TokenFilter {
    private Integer maxTokenCount;
    private Boolean allTokensConsumed;

    public LimitTokenFilter(String name) {
        super(name);
    }

    public Integer getMaxTokenCount() {
        return this.maxTokenCount;
    }

    public LimitTokenFilter setMaxTokenCount(Integer maxTokenCount) {
        this.maxTokenCount = maxTokenCount;
        return this;
    }

    public Boolean areAllTokensConsumed() {
        return this.allTokensConsumed;
    }

    public LimitTokenFilter setAllTokensConsumed(Boolean allTokensConsumed) {
        this.allTokensConsumed = allTokensConsumed;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("@odata.type", "#Microsoft.Azure.Search.LimitTokenFilter");
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeNumberField("maxTokenCount", (Number)this.maxTokenCount);
        jsonWriter.writeBooleanField("consumeAllTokens", this.allTokensConsumed);
        return jsonWriter.writeEndObject();
    }

    public static LimitTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return (LimitTokenFilter)jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            Integer maxTokenCount = null;
            Boolean allTokensConsumed = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("@odata.type".equals(fieldName)) {
                    String odataType = reader.getString();
                    if ("#Microsoft.Azure.Search.LimitTokenFilter".equals(odataType)) continue;
                    throw new IllegalStateException("'@odata.type' was expected to be non-null and equal to '#Microsoft.Azure.Search.LimitTokenFilter'. The found '@odata.type' was '" + odataType + "'.");
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                    continue;
                }
                if ("maxTokenCount".equals(fieldName)) {
                    maxTokenCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("consumeAllTokens".equals(fieldName)) {
                    allTokensConsumed = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            if (nameFound) {
                LimitTokenFilter deserializedLimitTokenFilter = new LimitTokenFilter(name);
                deserializedLimitTokenFilter.maxTokenCount = maxTokenCount;
                deserializedLimitTokenFilter.allTokensConsumed = allTokensConsumed;
                return deserializedLimitTokenFilter;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

