/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class SearchError
implements JsonSerializable<SearchError> {
    private String code;
    private final String message;
    private List<SearchError> details;

    public SearchError(String message) {
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public List<SearchError> getDetails() {
        return this.details;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static SearchError fromJson(JsonReader jsonReader) throws IOException {
        return (SearchError)jsonReader.readObject(reader -> {
            boolean messageFound = false;
            String message = null;
            String code = null;
            List details = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("message".equals(fieldName)) {
                    message = reader.getString();
                    messageFound = true;
                    continue;
                }
                if ("code".equals(fieldName)) {
                    code = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    details = reader.readArray(reader1 -> SearchError.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            if (messageFound) {
                SearchError deserializedSearchError = new SearchError(message);
                deserializedSearchError.code = code;
                deserializedSearchError.details = details;
                return deserializedSearchError;
            }
            ArrayList<String> missingProperties = new ArrayList<String>();
            if (!messageFound) {
                missingProperties.add("message");
            }
            throw new IllegalStateException("Missing required property/properties: " + String.join((CharSequence)", ", missingProperties));
        });
    }
}

