/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.models;

import com.azure.search.documents.indexes.models.CharFilterName;
import com.azure.search.documents.indexes.models.LexicalAnalyzer;
import com.azure.search.documents.indexes.models.LexicalTokenizerName;
import com.azure.search.documents.indexes.models.TokenFilterName;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Arrays;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@odata.type")
@JsonTypeName(value="#Microsoft.Azure.Search.CustomAnalyzer")
public final class CustomAnalyzer
extends LexicalAnalyzer {
    @JsonProperty(value="tokenizer", required=true)
    private LexicalTokenizerName tokenizerName;
    @JsonProperty(value="tokenFilters")
    private List<TokenFilterName> tokenFilters;
    @JsonProperty(value="charFilters")
    private List<CharFilterName> charFilters;

    public CustomAnalyzer(String name, LexicalTokenizerName tokenizerName) {
        super(name);
        this.tokenizerName = tokenizerName;
    }

    public LexicalTokenizerName getTokenizer() {
        return this.tokenizerName;
    }

    public List<TokenFilterName> getTokenFilters() {
        return this.tokenFilters;
    }

    public CustomAnalyzer setTokenFilters(TokenFilterName ... tokenFilters) {
        this.tokenFilters = tokenFilters == null ? null : Arrays.asList(tokenFilters);
        return this;
    }

    @JsonSetter
    public CustomAnalyzer setTokenFilters(List<TokenFilterName> tokenFilters) {
        this.tokenFilters = tokenFilters;
        return this;
    }

    public List<CharFilterName> getCharFilters() {
        return this.charFilters;
    }

    public CustomAnalyzer setCharFilters(CharFilterName ... charFilters) {
        this.charFilters = charFilters == null ? null : Arrays.asList(charFilters);
        return this;
    }

    @JsonSetter
    public CustomAnalyzer setCharFilters(List<CharFilterName> charFilters) {
        this.charFilters = charFilters;
        return this;
    }
}

