/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.search.documents.indexes.implementation.models.InputFieldMappingEntry;
import com.azure.search.documents.indexes.implementation.models.OutputFieldMappingEntry;
import com.azure.search.documents.indexes.implementation.models.SearchIndexerSkill;
import com.azure.search.documents.indexes.implementation.models.TextTranslationSkillLanguage;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@odata\\.type")
@JsonTypeName(value="#Microsoft.Skills.Text.TranslationSkill")
@JsonFlatten
public class TextTranslationSkill
extends SearchIndexerSkill {
    @JsonProperty(value="defaultToLanguageCode", required=true)
    private TextTranslationSkillLanguage defaultToLanguageCode;
    @JsonProperty(value="defaultFromLanguageCode")
    private TextTranslationSkillLanguage defaultFromLanguageCode;
    @JsonProperty(value="suggestedFrom")
    private TextTranslationSkillLanguage suggestedFrom;

    @JsonCreator
    public TextTranslationSkill(@JsonProperty(value="inputs") List<InputFieldMappingEntry> inputs, @JsonProperty(value="outputs") List<OutputFieldMappingEntry> outputs, @JsonProperty(value="defaultToLanguageCode") TextTranslationSkillLanguage defaultToLanguageCode) {
        super(inputs, outputs);
        this.defaultToLanguageCode = defaultToLanguageCode;
    }

    public TextTranslationSkillLanguage getDefaultToLanguageCode() {
        return this.defaultToLanguageCode;
    }

    public TextTranslationSkillLanguage getDefaultFromLanguageCode() {
        return this.defaultFromLanguageCode;
    }

    public TextTranslationSkill setDefaultFromLanguageCode(TextTranslationSkillLanguage defaultFromLanguageCode) {
        this.defaultFromLanguageCode = defaultFromLanguageCode;
        return this;
    }

    public TextTranslationSkillLanguage getSuggestedFrom() {
        return this.suggestedFrom;
    }

    public TextTranslationSkill setSuggestedFrom(TextTranslationSkillLanguage suggestedFrom) {
        this.suggestedFrom = suggestedFrom;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getDefaultToLanguageCode() == null) {
            throw new IllegalArgumentException("Missing required property defaultToLanguageCode in model TextTranslationSkill");
        }
    }
}

