/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.search.documents.indexes.implementation.models.ResourceCounter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ServiceCounters {
    @JsonProperty(value="documentCount", required=true)
    private ResourceCounter documentCounter;
    @JsonProperty(value="indexesCount", required=true)
    private ResourceCounter indexCounter;
    @JsonProperty(value="indexersCount", required=true)
    private ResourceCounter indexerCounter;
    @JsonProperty(value="dataSourcesCount", required=true)
    private ResourceCounter dataSourceCounter;
    @JsonProperty(value="storageSize", required=true)
    private ResourceCounter storageSizeCounter;
    @JsonProperty(value="synonymMaps", required=true)
    private ResourceCounter synonymMapCounter;

    @JsonCreator
    public ServiceCounters(@JsonProperty(value="documentCount") ResourceCounter documentCounter, @JsonProperty(value="indexesCount") ResourceCounter indexCounter, @JsonProperty(value="indexersCount") ResourceCounter indexerCounter, @JsonProperty(value="dataSourcesCount") ResourceCounter dataSourceCounter, @JsonProperty(value="storageSize") ResourceCounter storageSizeCounter, @JsonProperty(value="synonymMaps") ResourceCounter synonymMapCounter) {
        this.documentCounter = documentCounter;
        this.indexCounter = indexCounter;
        this.indexerCounter = indexerCounter;
        this.dataSourceCounter = dataSourceCounter;
        this.storageSizeCounter = storageSizeCounter;
        this.synonymMapCounter = synonymMapCounter;
    }

    public ResourceCounter getDocumentCounter() {
        return this.documentCounter;
    }

    public ResourceCounter getIndexCounter() {
        return this.indexCounter;
    }

    public ResourceCounter getIndexerCounter() {
        return this.indexerCounter;
    }

    public ResourceCounter getDataSourceCounter() {
        return this.dataSourceCounter;
    }

    public ResourceCounter getStorageSizeCounter() {
        return this.storageSizeCounter;
    }

    public ResourceCounter getSynonymMapCounter() {
        return this.synonymMapCounter;
    }

    public void validate() {
        if (this.getDocumentCounter() == null) {
            throw new IllegalArgumentException("Missing required property documentCounter in model ServiceCounters");
        }
        this.getDocumentCounter().validate();
        if (this.getIndexCounter() == null) {
            throw new IllegalArgumentException("Missing required property indexCounter in model ServiceCounters");
        }
        this.getIndexCounter().validate();
        if (this.getIndexerCounter() == null) {
            throw new IllegalArgumentException("Missing required property indexerCounter in model ServiceCounters");
        }
        this.getIndexerCounter().validate();
        if (this.getDataSourceCounter() == null) {
            throw new IllegalArgumentException("Missing required property dataSourceCounter in model ServiceCounters");
        }
        this.getDataSourceCounter().validate();
        if (this.getStorageSizeCounter() == null) {
            throw new IllegalArgumentException("Missing required property storageSizeCounter in model ServiceCounters");
        }
        this.getStorageSizeCounter().validate();
        if (this.getSynonymMapCounter() == null) {
            throw new IllegalArgumentException("Missing required property synonymMapCounter in model ServiceCounters");
        }
        this.getSynonymMapCounter().validate();
    }
}

