/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.search.documents.indexes.implementation.models.DataChangeDetectionPolicy;
import com.azure.search.documents.indexes.implementation.models.DataDeletionDetectionPolicy;
import com.azure.search.documents.indexes.implementation.models.DataSourceCredentials;
import com.azure.search.documents.indexes.implementation.models.SearchIndexerDataContainer;
import com.azure.search.documents.indexes.implementation.models.SearchIndexerDataSourceType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class SearchIndexerDataSource {
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="type", required=true)
    private SearchIndexerDataSourceType type;
    @JsonProperty(value="credentials", required=true)
    private DataSourceCredentials credentials;
    @JsonProperty(value="container", required=true)
    private SearchIndexerDataContainer container;
    @JsonProperty(value="dataChangeDetectionPolicy")
    private DataChangeDetectionPolicy dataChangeDetectionPolicy;
    @JsonProperty(value="dataDeletionDetectionPolicy")
    private DataDeletionDetectionPolicy dataDeletionDetectionPolicy;
    @JsonProperty(value="@odata.etag")
    private String eTag;

    @JsonCreator
    public SearchIndexerDataSource(@JsonProperty(value="name") String name, @JsonProperty(value="type") SearchIndexerDataSourceType type, @JsonProperty(value="credentials") DataSourceCredentials credentials, @JsonProperty(value="container") SearchIndexerDataContainer container) {
        this.name = name;
        this.type = type;
        this.credentials = credentials;
        this.container = container;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public SearchIndexerDataSource setDescription(String description) {
        this.description = description;
        return this;
    }

    public SearchIndexerDataSourceType getType() {
        return this.type;
    }

    public DataSourceCredentials getCredentials() {
        return this.credentials;
    }

    public SearchIndexerDataContainer getContainer() {
        return this.container;
    }

    public DataChangeDetectionPolicy getDataChangeDetectionPolicy() {
        return this.dataChangeDetectionPolicy;
    }

    public SearchIndexerDataSource setDataChangeDetectionPolicy(DataChangeDetectionPolicy dataChangeDetectionPolicy) {
        this.dataChangeDetectionPolicy = dataChangeDetectionPolicy;
        return this;
    }

    public DataDeletionDetectionPolicy getDataDeletionDetectionPolicy() {
        return this.dataDeletionDetectionPolicy;
    }

    public SearchIndexerDataSource setDataDeletionDetectionPolicy(DataDeletionDetectionPolicy dataDeletionDetectionPolicy) {
        this.dataDeletionDetectionPolicy = dataDeletionDetectionPolicy;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public SearchIndexerDataSource setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public void validate() {
        if (this.getName() == null) {
            throw new IllegalArgumentException("Missing required property name in model SearchIndexerDataSource");
        }
        if (this.getType() == null) {
            throw new IllegalArgumentException("Missing required property type in model SearchIndexerDataSource");
        }
        if (this.getCredentials() == null) {
            throw new IllegalArgumentException("Missing required property credentials in model SearchIndexerDataSource");
        }
        this.getCredentials().validate();
        if (this.getContainer() == null) {
            throw new IllegalArgumentException("Missing required property container in model SearchIndexerDataSource");
        }
        this.getContainer().validate();
        if (this.getDataChangeDetectionPolicy() != null) {
            this.getDataChangeDetectionPolicy().validate();
        }
        if (this.getDataDeletionDetectionPolicy() != null) {
            this.getDataDeletionDetectionPolicy().validate();
        }
    }
}

