/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.search.documents.indexes.implementation.models.FieldMapping;
import com.azure.search.documents.indexes.implementation.models.IndexingParameters;
import com.azure.search.documents.indexes.implementation.models.IndexingSchedule;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class SearchIndexer {
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="dataSourceName", required=true)
    private String dataSourceName;
    @JsonProperty(value="skillsetName")
    private String skillsetName;
    @JsonProperty(value="targetIndexName", required=true)
    private String targetIndexName;
    @JsonProperty(value="schedule")
    private IndexingSchedule schedule;
    @JsonProperty(value="parameters")
    private IndexingParameters parameters;
    @JsonProperty(value="fieldMappings")
    private List<FieldMapping> fieldMappings;
    @JsonProperty(value="outputFieldMappings")
    private List<FieldMapping> outputFieldMappings;
    @JsonProperty(value="disabled")
    private Boolean isDisabled;
    @JsonProperty(value="@odata.etag")
    private String eTag;

    @JsonCreator
    public SearchIndexer(@JsonProperty(value="name") String name, @JsonProperty(value="dataSourceName") String dataSourceName, @JsonProperty(value="targetIndexName") String targetIndexName) {
        this.name = name;
        this.dataSourceName = dataSourceName;
        this.targetIndexName = targetIndexName;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public SearchIndexer setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getSkillsetName() {
        return this.skillsetName;
    }

    public SearchIndexer setSkillsetName(String skillsetName) {
        this.skillsetName = skillsetName;
        return this;
    }

    public String getTargetIndexName() {
        return this.targetIndexName;
    }

    public IndexingSchedule getSchedule() {
        return this.schedule;
    }

    public SearchIndexer setSchedule(IndexingSchedule schedule) {
        this.schedule = schedule;
        return this;
    }

    public IndexingParameters getParameters() {
        return this.parameters;
    }

    public SearchIndexer setParameters(IndexingParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    public List<FieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public SearchIndexer setFieldMappings(List<FieldMapping> fieldMappings) {
        this.fieldMappings = fieldMappings;
        return this;
    }

    public List<FieldMapping> getOutputFieldMappings() {
        return this.outputFieldMappings;
    }

    public SearchIndexer setOutputFieldMappings(List<FieldMapping> outputFieldMappings) {
        this.outputFieldMappings = outputFieldMappings;
        return this;
    }

    public Boolean isDisabled() {
        return this.isDisabled;
    }

    public SearchIndexer setIsDisabled(Boolean isDisabled) {
        this.isDisabled = isDisabled;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public SearchIndexer setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public void validate() {
        if (this.getName() == null) {
            throw new IllegalArgumentException("Missing required property name in model SearchIndexer");
        }
        if (this.getDataSourceName() == null) {
            throw new IllegalArgumentException("Missing required property dataSourceName in model SearchIndexer");
        }
        if (this.getTargetIndexName() == null) {
            throw new IllegalArgumentException("Missing required property targetIndexName in model SearchIndexer");
        }
        if (this.getSchedule() != null) {
            this.getSchedule().validate();
        }
        if (this.getParameters() != null) {
            this.getParameters().validate();
        }
        if (this.getFieldMappings() != null) {
            this.getFieldMappings().forEach(e -> e.validate());
        }
        if (this.getOutputFieldMappings() != null) {
            this.getOutputFieldMappings().forEach(e -> e.validate());
        }
    }
}

