/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.search.documents.indexes.implementation.models.ScoringFunction;
import com.azure.search.documents.indexes.implementation.models.ScoringFunctionAggregation;
import com.azure.search.documents.indexes.implementation.models.TextWeights;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ScoringProfile {
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="text")
    private TextWeights textWeights;
    @JsonProperty(value="functions")
    private List<ScoringFunction> functions;
    @JsonProperty(value="functionAggregation")
    private ScoringFunctionAggregation functionAggregation;

    @JsonCreator
    public ScoringProfile(@JsonProperty(value="name") String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public TextWeights getTextWeights() {
        return this.textWeights;
    }

    public ScoringProfile setTextWeights(TextWeights textWeights) {
        this.textWeights = textWeights;
        return this;
    }

    public List<ScoringFunction> getFunctions() {
        return this.functions;
    }

    public ScoringProfile setFunctions(List<ScoringFunction> functions) {
        this.functions = functions;
        return this;
    }

    public ScoringFunctionAggregation getFunctionAggregation() {
        return this.functionAggregation;
    }

    public ScoringProfile setFunctionAggregation(ScoringFunctionAggregation functionAggregation) {
        this.functionAggregation = functionAggregation;
        return this;
    }

    public void validate() {
        if (this.getName() == null) {
            throw new IllegalArgumentException("Missing required property name in model ScoringProfile");
        }
        if (this.getTextWeights() != null) {
            this.getTextWeights().validate();
        }
        if (this.getFunctions() != null) {
            this.getFunctions().forEach(e -> e.validate());
        }
    }
}

