/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.search.documents.indexes.implementation.models.TokenFilter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@odata\\.type")
@JsonTypeName(value="#Microsoft.Azure.Search.KeywordMarkerTokenFilter")
@JsonFlatten
public class KeywordMarkerTokenFilter
extends TokenFilter {
    @JsonProperty(value="keywords", required=true)
    private List<String> keywords;
    @JsonProperty(value="ignoreCase")
    private Boolean ignoreCase;

    @JsonCreator
    public KeywordMarkerTokenFilter(@JsonProperty(value="name") String name, @JsonProperty(value="keywords") List<String> keywords) {
        super(name);
        this.keywords = keywords;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public Boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public KeywordMarkerTokenFilter setIgnoreCase(Boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getKeywords() == null) {
            throw new IllegalArgumentException("Missing required property keywords in model KeywordMarkerTokenFilter");
        }
    }
}

