/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.search.documents.indexes.implementation.models.TokenFilter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@odata\\.type")
@JsonTypeName(value="#Microsoft.Azure.Search.KeepTokenFilter")
@JsonFlatten
public class KeepTokenFilter
extends TokenFilter {
    @JsonProperty(value="keepWords", required=true)
    private List<String> keepWords;
    @JsonProperty(value="keepWordsCase")
    private Boolean lowerCaseKeepWords;

    @JsonCreator
    public KeepTokenFilter(@JsonProperty(value="name") String name, @JsonProperty(value="keepWords") List<String> keepWords) {
        super(name);
        this.keepWords = keepWords;
    }

    public List<String> getKeepWords() {
        return this.keepWords;
    }

    public Boolean isLowerCaseKeepWords() {
        return this.lowerCaseKeepWords;
    }

    public KeepTokenFilter setLowerCaseKeepWords(Boolean lowerCaseKeepWords) {
        this.lowerCaseKeepWords = lowerCaseKeepWords;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getKeepWords() == null) {
            throw new IllegalArgumentException("Missing required property keepWords in model KeepTokenFilter");
        }
    }
}

