/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation.models;

import com.azure.search.documents.indexes.implementation.models.IndexerExecutionStatus;
import com.azure.search.documents.indexes.implementation.models.SearchIndexerError;
import com.azure.search.documents.indexes.implementation.models.SearchIndexerWarning;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class IndexerExecutionResult {
    @JsonProperty(value="status", required=true, access=JsonProperty.Access.WRITE_ONLY)
    private IndexerExecutionStatus status;
    @JsonProperty(value="errorMessage", access=JsonProperty.Access.WRITE_ONLY)
    private String errorMessage;
    @JsonProperty(value="startTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime startTime;
    @JsonProperty(value="endTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime endTime;
    @JsonProperty(value="errors", required=true, access=JsonProperty.Access.WRITE_ONLY)
    private List<SearchIndexerError> errors;
    @JsonProperty(value="warnings", required=true, access=JsonProperty.Access.WRITE_ONLY)
    private List<SearchIndexerWarning> warnings;
    @JsonProperty(value="itemsProcessed", required=true, access=JsonProperty.Access.WRITE_ONLY)
    private int itemCount;
    @JsonProperty(value="itemsFailed", required=true, access=JsonProperty.Access.WRITE_ONLY)
    private int failedItemCount;
    @JsonProperty(value="initialTrackingState", access=JsonProperty.Access.WRITE_ONLY)
    private String initialTrackingState;
    @JsonProperty(value="finalTrackingState", access=JsonProperty.Access.WRITE_ONLY)
    private String finalTrackingState;

    @JsonCreator
    public IndexerExecutionResult(@JsonProperty(value="status") IndexerExecutionStatus status, @JsonProperty(value="errors") List<SearchIndexerError> errors, @JsonProperty(value="warnings") List<SearchIndexerWarning> warnings, @JsonProperty(value="itemsProcessed") int itemCount, @JsonProperty(value="itemsFailed") int failedItemCount) {
        this.status = status;
        this.errors = errors;
        this.warnings = warnings;
        this.itemCount = itemCount;
        this.failedItemCount = failedItemCount;
    }

    public IndexerExecutionStatus getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public List<SearchIndexerError> getErrors() {
        return this.errors;
    }

    public List<SearchIndexerWarning> getWarnings() {
        return this.warnings;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public int getFailedItemCount() {
        return this.failedItemCount;
    }

    public String getInitialTrackingState() {
        return this.initialTrackingState;
    }

    public String getFinalTrackingState() {
        return this.finalTrackingState;
    }

    public void validate() {
        if (this.getErrors() != null) {
            this.getErrors().forEach(e -> e.validate());
        }
        if (this.getWarnings() != null) {
            this.getWarnings().forEach(e -> e.validate());
        }
    }
}

