/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.indexes.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.search.documents.indexes.implementation.SearchServiceClientImpl;
import com.azure.search.documents.indexes.implementation.models.ListSynonymMapsResult;
import com.azure.search.documents.indexes.implementation.models.RequestOptions;
import com.azure.search.documents.indexes.implementation.models.SearchErrorException;
import com.azure.search.documents.indexes.implementation.models.SynonymMap;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class SynonymMapsImpl {
    private final SynonymMapsService service;
    private final SearchServiceClientImpl client;

    SynonymMapsImpl(SearchServiceClientImpl client) {
        this.service = (SynonymMapsService)RestProxy.create(SynonymMapsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    public Mono<Response<SynonymMap>> createOrUpdateWithResponseAsync(String synonymMapName, SynonymMap synonymMap, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (synonymMapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter synonymMapName is required and cannot be null."));
        }
        if (synonymMap == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter synonymMap is required and cannot be null."));
        }
        synonymMap.validate();
        if (requestOptions != null) {
            requestOptions.validate();
        }
        String prefer = "return=representation";
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.createOrUpdate(this.client.getEndpoint(), synonymMapName, xMsClientRequestId, ifMatch, ifNoneMatch, "return=representation", this.client.getApiVersion(), "application/json; odata.metadata=minimal", synonymMap, context);
    }

    public Mono<Response<Void>> deleteWithResponseAsync(String synonymMapName, String ifMatch, String ifNoneMatch, RequestOptions requestOptions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (synonymMapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter synonymMapName is required and cannot be null."));
        }
        if (requestOptions != null) {
            requestOptions.validate();
        }
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.delete(this.client.getEndpoint(), synonymMapName, xMsClientRequestId, ifMatch, ifNoneMatch, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    public Mono<Response<SynonymMap>> getWithResponseAsync(String synonymMapName, RequestOptions requestOptions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (synonymMapName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter synonymMapName is required and cannot be null."));
        }
        if (requestOptions != null) {
            requestOptions.validate();
        }
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.get(this.client.getEndpoint(), synonymMapName, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    public Mono<Response<ListSynonymMapsResult>> listWithResponseAsync(String select, RequestOptions requestOptions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (requestOptions != null) {
            requestOptions.validate();
        }
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.list(this.client.getEndpoint(), select, xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", context);
    }

    public Mono<Response<SynonymMap>> createWithResponseAsync(SynonymMap synonymMap, RequestOptions requestOptions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (synonymMap == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter synonymMap is required and cannot be null."));
        }
        synonymMap.validate();
        if (requestOptions != null) {
            requestOptions.validate();
        }
        String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return this.service.create(this.client.getEndpoint(), xMsClientRequestId, this.client.getApiVersion(), "application/json; odata.metadata=minimal", synonymMap, context);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="SearchServiceClientS")
    private static interface SynonymMapsService {
        @Put(value="/synonymmaps('{synonymMapName}')")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<SynonymMap>> createOrUpdate(@HostParam(value="endpoint") String var1, @PathParam(value="synonymMapName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @HeaderParam(value="Prefer") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="accept") String var8, @BodyParam(value="application/json") SynonymMap var9, Context var10);

        @Delete(value="/synonymmaps('{synonymMapName}')")
        @ExpectedResponses(value={204, 404})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<Void>> delete(@HostParam(value="endpoint") String var1, @PathParam(value="synonymMapName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="If-None-Match") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="accept") String var7, Context var8);

        @Get(value="/synonymmaps('{synonymMapName}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<SynonymMap>> get(@HostParam(value="endpoint") String var1, @PathParam(value="synonymMapName") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept") String var5, Context var6);

        @Get(value="/synonymmaps")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<ListSynonymMapsResult>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="$select") String var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="accept") String var5, Context var6);

        @Post(value="/synonymmaps")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=SearchErrorException.class)
        public Mono<Response<SynonymMap>> create(@HostParam(value="endpoint") String var1, @HeaderParam(value="x-ms-client-request-id") UUID var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="accept") String var4, @BodyParam(value="application/json") SynonymMap var5, Context var6);
    }
}

