/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.util;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.search.documents.implementation.converters.AnalyzedTokenInfoConverter;
import com.azure.search.documents.implementation.converters.AutocompleteResultConverter;
import com.azure.search.documents.implementation.converters.GetIndexStatisticsResultConverter;
import com.azure.search.documents.implementation.converters.IndexDocumentsResultConverter;
import com.azure.search.documents.implementation.converters.SearchIndexConverter;
import com.azure.search.documents.implementation.converters.SearchIndexerConverter;
import com.azure.search.documents.implementation.converters.SearchIndexerDataSourceConverter;
import com.azure.search.documents.implementation.converters.SearchIndexerSkillsetConverter;
import com.azure.search.documents.implementation.converters.SearchIndexerStatusConverter;
import com.azure.search.documents.implementation.converters.ServiceStatisticsConverter;
import com.azure.search.documents.implementation.converters.SynonymMapConverter;
import com.azure.search.documents.implementation.models.IndexDocumentsResult;
import com.azure.search.documents.indexes.implementation.models.AnalyzeResult;
import com.azure.search.documents.indexes.implementation.models.GetIndexStatisticsResult;
import com.azure.search.documents.indexes.implementation.models.ListDataSourcesResult;
import com.azure.search.documents.indexes.implementation.models.ListIndexersResult;
import com.azure.search.documents.indexes.implementation.models.ListSkillsetsResult;
import com.azure.search.documents.indexes.implementation.models.ListSynonymMapsResult;
import com.azure.search.documents.indexes.implementation.models.SearchErrorException;
import com.azure.search.documents.indexes.implementation.models.SearchIndex;
import com.azure.search.documents.indexes.implementation.models.SearchIndexerDataSource;
import com.azure.search.documents.indexes.implementation.models.SearchIndexerSkillset;
import com.azure.search.documents.indexes.implementation.models.ServiceStatistics;
import com.azure.search.documents.indexes.implementation.models.SynonymMap;
import com.azure.search.documents.indexes.models.AnalyzedTokenInfo;
import com.azure.search.documents.indexes.models.SearchIndexStatistics;
import com.azure.search.documents.indexes.models.SearchIndexer;
import com.azure.search.documents.indexes.models.SearchIndexerDataSourceConnection;
import com.azure.search.documents.indexes.models.SearchIndexerStatus;
import com.azure.search.documents.indexes.models.SearchServiceStatistics;
import com.azure.search.documents.models.AutocompleteResult;
import com.azure.search.documents.util.AutocompletePagedResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class MappingUtils {
    public static Response<SearchIndexerDataSourceConnection> mappingExternalDataSource(Response<SearchIndexerDataSource> dataSourceResponse) {
        return new SimpleResponse(dataSourceResponse, (Object)SearchIndexerDataSourceConverter.map((SearchIndexerDataSource)dataSourceResponse.getValue()));
    }

    public static PagedResponse<SearchIndexerDataSourceConnection> mappingPagingDataSource(Response<ListDataSourcesResult> dataSourceResponse) {
        List dataSourceMaps = ((ListDataSourcesResult)dataSourceResponse.getValue()).getDataSources().stream().map(SearchIndexerDataSourceConverter::map).collect(Collectors.toList());
        return new PagedResponseBase(dataSourceResponse.getRequest(), dataSourceResponse.getStatusCode(), dataSourceResponse.getHeaders(), dataSourceMaps, null, null);
    }

    public static PagedResponse<String> mappingPagingDataSourceNames(Response<ListDataSourcesResult> dataSourceResponse) {
        List dataSourceNames = ((ListDataSourcesResult)dataSourceResponse.getValue()).getDataSources().stream().map(SearchIndexerDataSourceConverter::map).map(SearchIndexerDataSourceConnection::getName).collect(Collectors.toList());
        return new PagedResponseBase(dataSourceResponse.getRequest(), dataSourceResponse.getStatusCode(), dataSourceResponse.getHeaders(), dataSourceNames, null, null);
    }

    public static PagedResponse<String> mappingPagingSearchIndexNames(PagedResponse<com.azure.search.documents.indexes.models.SearchIndex> searchIndexResponse) {
        ArrayList pageItems = new ArrayList();
        searchIndexResponse.getValue().forEach(item -> pageItems.add(item.getName()));
        return new PagedResponseBase(searchIndexResponse.getRequest(), searchIndexResponse.getStatusCode(), searchIndexResponse.getHeaders(), pageItems, (String)searchIndexResponse.getContinuationToken(), null);
    }

    public static Response<com.azure.search.documents.indexes.models.SearchIndex> mappingExternalSearchIndex(Response<SearchIndex> indexResponse) {
        return new SimpleResponse(indexResponse, (Object)SearchIndexConverter.map((SearchIndex)indexResponse.getValue()));
    }

    public static PagedResponse<com.azure.search.documents.indexes.models.SearchIndex> mappingListingSearchIndex(PagedResponse<SearchIndex> indexResponse) {
        ArrayList pageItems = new ArrayList();
        indexResponse.getValue().forEach(item -> pageItems.add(SearchIndexConverter.map(item)));
        return new PagedResponseBase(indexResponse.getRequest(), indexResponse.getStatusCode(), indexResponse.getHeaders(), pageItems, (String)indexResponse.getContinuationToken(), null);
    }

    public static PagedResponse<SearchIndexer> mappingPagingSearchIndexer(Response<ListIndexersResult> searchIndexerResponse) {
        List searchIndexers = ((ListIndexersResult)searchIndexerResponse.getValue()).getIndexers().stream().map(SearchIndexerConverter::map).collect(Collectors.toList());
        return new PagedResponseBase(searchIndexerResponse.getRequest(), searchIndexerResponse.getStatusCode(), searchIndexerResponse.getHeaders(), searchIndexers, null, null);
    }

    public static PagedResponse<String> mappingPagingSearchIndexerNames(Response<ListIndexersResult> searchIndexerResponse) {
        List searchIndexerNames = ((ListIndexersResult)searchIndexerResponse.getValue()).getIndexers().stream().map(SearchIndexerConverter::map).map(SearchIndexer::getName).collect(Collectors.toList());
        return new PagedResponseBase(searchIndexerResponse.getRequest(), searchIndexerResponse.getStatusCode(), searchIndexerResponse.getHeaders(), searchIndexerNames, null, null);
    }

    public static Response<SearchIndexer> mappingExternalSearchIndexer(Response<com.azure.search.documents.indexes.implementation.models.SearchIndexer> indexerResponse) {
        return new SimpleResponse(indexerResponse, (Object)SearchIndexerConverter.map((com.azure.search.documents.indexes.implementation.models.SearchIndexer)indexerResponse.getValue()));
    }

    public static Response<com.azure.search.documents.indexes.models.SearchIndexerSkillset> mappingExternalSkillset(Response<SearchIndexerSkillset> skillsetResponse) {
        return new SimpleResponse(skillsetResponse, (Object)SearchIndexerSkillsetConverter.map((SearchIndexerSkillset)skillsetResponse.getValue()));
    }

    public static PagedResponse<com.azure.search.documents.indexes.models.SearchIndexerSkillset> mappingPagingSkillset(Response<ListSkillsetsResult> skillsetResponse) {
        List skillsets = ((ListSkillsetsResult)skillsetResponse.getValue()).getSkillsets().stream().map(SearchIndexerSkillsetConverter::map).collect(Collectors.toList());
        return new PagedResponseBase(skillsetResponse.getRequest(), skillsetResponse.getStatusCode(), skillsetResponse.getHeaders(), skillsets, null, null);
    }

    public static PagedResponse<String> mappingPagingSkillsetNames(Response<ListSkillsetsResult> skillsetResponse) {
        List skillsetNames = ((ListSkillsetsResult)skillsetResponse.getValue()).getSkillsets().stream().map(SearchIndexerSkillsetConverter::map).map(com.azure.search.documents.indexes.models.SearchIndexerSkillset::getName).collect(Collectors.toList());
        return new PagedResponseBase(skillsetResponse.getRequest(), skillsetResponse.getStatusCode(), skillsetResponse.getHeaders(), skillsetNames, null, null);
    }

    public static Response<com.azure.search.documents.indexes.models.SynonymMap> mappingExternalSynonymMap(Response<SynonymMap> synonymMapResponse) {
        return new SimpleResponse(synonymMapResponse, (Object)SynonymMapConverter.map((SynonymMap)synonymMapResponse.getValue()));
    }

    public static PagedResponse<com.azure.search.documents.indexes.models.SynonymMap> mappingPagingSynonymMap(Response<ListSynonymMapsResult> synonymMapResponse) {
        List synonymMaps = ((ListSynonymMapsResult)synonymMapResponse.getValue()).getSynonymMaps().stream().map(SynonymMapConverter::map).collect(Collectors.toList());
        return new PagedResponseBase(synonymMapResponse.getRequest(), synonymMapResponse.getStatusCode(), synonymMapResponse.getHeaders(), synonymMaps, null, null);
    }

    public static PagedResponse<String> mappingPagingSynonymMapNames(Response<ListSynonymMapsResult> synonymMapsResponse) {
        List synonymMapNames = ((ListSynonymMapsResult)synonymMapsResponse.getValue()).getSynonymMaps().stream().map(SynonymMapConverter::map).map(com.azure.search.documents.indexes.models.SynonymMap::getName).collect(Collectors.toList());
        return new PagedResponseBase(synonymMapsResponse.getRequest(), synonymMapsResponse.getStatusCode(), synonymMapsResponse.getHeaders(), synonymMapNames, null, null);
    }

    public static Response<SearchServiceStatistics> mappingExternalServiceStatistics(Response<ServiceStatistics> statisticsResponse) {
        return new SimpleResponse(statisticsResponse, (Object)ServiceStatisticsConverter.map((ServiceStatistics)statisticsResponse.getValue()));
    }

    public static PagedResponse<AnalyzedTokenInfo> mappingTokenInfo(Response<AnalyzeResult> resultResponse) {
        List tokenInfos = ((AnalyzeResult)resultResponse.getValue()).getTokens().stream().map(AnalyzedTokenInfoConverter::map).collect(Collectors.toList());
        return new PagedResponseBase(resultResponse.getRequest(), resultResponse.getStatusCode(), resultResponse.getHeaders(), tokenInfos, null, null);
    }

    public static Response<SearchIndexerStatus> mappingIndexerStatus(Response<com.azure.search.documents.indexes.implementation.models.SearchIndexerStatus> indexerStatusResponse) {
        return new SimpleResponse(indexerStatusResponse, (Object)SearchIndexerStatusConverter.map((com.azure.search.documents.indexes.implementation.models.SearchIndexerStatus)indexerStatusResponse.getValue()));
    }

    public static Response<SearchIndexStatistics> mappingGetIndexStatistics(Response<GetIndexStatisticsResult> indexStatisticsResponse) {
        return new SimpleResponse(indexStatisticsResponse.getRequest(), indexStatisticsResponse.getStatusCode(), indexStatisticsResponse.getHeaders(), (Object)GetIndexStatisticsResultConverter.map((GetIndexStatisticsResult)indexStatisticsResponse.getValue()));
    }

    public static AutocompletePagedResponse mappingAutocompleteResponse(Response<com.azure.search.documents.implementation.models.AutocompleteResult> autocompleteResultResponse) {
        return new AutocompletePagedResponse((SimpleResponse<AutocompleteResult>)new SimpleResponse(autocompleteResultResponse, (Object)AutocompleteResultConverter.map((com.azure.search.documents.implementation.models.AutocompleteResult)autocompleteResultResponse.getValue())));
    }

    public static Response<com.azure.search.documents.models.IndexDocumentsResult> mappingIndexDocumentResultResponse(Response<IndexDocumentsResult> indexDocumentResponse) {
        return new SimpleResponse(indexDocumentResponse, (Object)IndexDocumentsResultConverter.map((IndexDocumentsResult)indexDocumentResponse.getValue()));
    }

    public static Throwable exceptionMapper(Throwable throwable) {
        if (throwable instanceof SearchErrorException) {
            SearchErrorException exception = (SearchErrorException)((Object)throwable);
            return new HttpResponseException(exception.getMessage(), exception.getResponse());
        }
        if (throwable instanceof com.azure.search.documents.implementation.models.SearchErrorException) {
            com.azure.search.documents.implementation.models.SearchErrorException exception = (com.azure.search.documents.implementation.models.SearchErrorException)((Object)throwable);
            return new HttpResponseException(exception.getMessage(), exception.getResponse());
        }
        return throwable;
    }
}

