/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public final class Iso8601DateSerializer
extends JsonSerializer<Date> {
    public static SimpleModule getModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(Date.class, (JsonSerializer)new Iso8601DateSerializer());
        return module;
    }

    public void serialize(Date dateValue, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        String dateString = dateValue.toInstant().atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        gen.writeString(dateString);
    }
}

