/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.search.documents.implementation.converters.StopwordsListConverter;
import com.azure.search.documents.indexes.implementation.models.StopwordsList;
import com.azure.search.documents.indexes.models.StopwordsTokenFilter;
import java.util.ArrayList;

public final class StopwordsTokenFilterConverter {
    public static StopwordsTokenFilter map(com.azure.search.documents.indexes.implementation.models.StopwordsTokenFilter obj) {
        if (obj == null) {
            return null;
        }
        StopwordsTokenFilter stopwordsTokenFilter = new StopwordsTokenFilter(obj.getName());
        Boolean removeTrailingStopWords = obj.isRemoveTrailingStopWords();
        stopwordsTokenFilter.setTrailingStopWordsRemoved(removeTrailingStopWords);
        Boolean ignoreCase = obj.isIgnoreCase();
        stopwordsTokenFilter.setCaseIgnored(ignoreCase);
        if (obj.getStopwords() != null) {
            ArrayList<String> stopwords = new ArrayList<String>(obj.getStopwords());
            stopwordsTokenFilter.setStopwords(stopwords);
        }
        if (obj.getStopwordsList() != null) {
            com.azure.search.documents.indexes.models.StopwordsList stopwordsList = StopwordsListConverter.map(obj.getStopwordsList());
            stopwordsTokenFilter.setStopwordsList(stopwordsList);
        }
        return stopwordsTokenFilter;
    }

    public static com.azure.search.documents.indexes.implementation.models.StopwordsTokenFilter map(StopwordsTokenFilter obj) {
        if (obj == null) {
            return null;
        }
        com.azure.search.documents.indexes.implementation.models.StopwordsTokenFilter stopwordsTokenFilter = new com.azure.search.documents.indexes.implementation.models.StopwordsTokenFilter(obj.getName());
        Boolean removeTrailingStopWords = obj.areTrailingStopWordsRemoved();
        stopwordsTokenFilter.setRemoveTrailingStopWords(removeTrailingStopWords);
        Boolean ignoreCase = obj.isCaseIgnored();
        stopwordsTokenFilter.setIgnoreCase(ignoreCase);
        if (obj.getStopwords() != null) {
            ArrayList<String> stopwords = new ArrayList<String>(obj.getStopwords());
            stopwordsTokenFilter.setStopwords(stopwords);
        }
        if (obj.getStopwordsList() != null) {
            StopwordsList stopwordsList = StopwordsListConverter.map(obj.getStopwordsList());
            stopwordsTokenFilter.setStopwordsList(stopwordsList);
        }
        stopwordsTokenFilter.validate();
        return stopwordsTokenFilter;
    }

    private StopwordsTokenFilterConverter() {
    }
}

