/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.search.documents.implementation.converters.ScoringFunctionAggregationConverter;
import com.azure.search.documents.implementation.converters.ScoringFunctionConverter;
import com.azure.search.documents.implementation.converters.TextWeightsConverter;
import com.azure.search.documents.indexes.implementation.models.ScoringFunction;
import com.azure.search.documents.indexes.models.ScoringFunctionAggregation;
import com.azure.search.documents.indexes.models.ScoringProfile;
import com.azure.search.documents.indexes.models.TextWeights;
import java.util.List;
import java.util.stream.Collectors;

public final class ScoringProfileConverter {
    public static ScoringProfile map(com.azure.search.documents.indexes.implementation.models.ScoringProfile obj) {
        if (obj == null) {
            return null;
        }
        ScoringProfile scoringProfile = new ScoringProfile(obj.getName());
        if (obj.getFunctions() != null) {
            scoringProfile.setFunctions(obj.getFunctions().stream().map(ScoringFunctionConverter::map).collect(Collectors.toList()));
        }
        if (obj.getTextWeights() != null) {
            TextWeights textWeights = TextWeightsConverter.map(obj.getTextWeights());
            scoringProfile.setTextWeights(textWeights);
        }
        if (obj.getFunctionAggregation() != null) {
            ScoringFunctionAggregation functionAggregation = ScoringFunctionAggregationConverter.map(obj.getFunctionAggregation());
            scoringProfile.setFunctionAggregation(functionAggregation);
        }
        return scoringProfile;
    }

    public static com.azure.search.documents.indexes.implementation.models.ScoringProfile map(ScoringProfile obj) {
        if (obj == null) {
            return null;
        }
        com.azure.search.documents.indexes.implementation.models.ScoringProfile scoringProfile = new com.azure.search.documents.indexes.implementation.models.ScoringProfile(obj.getName());
        if (obj.getFunctions() != null) {
            List<ScoringFunction> functions = obj.getFunctions().stream().map(ScoringFunctionConverter::map).collect(Collectors.toList());
            scoringProfile.setFunctions(functions);
        }
        if (obj.getTextWeights() != null) {
            com.azure.search.documents.indexes.implementation.models.TextWeights textWeights = TextWeightsConverter.map(obj.getTextWeights());
            scoringProfile.setTextWeights(textWeights);
        }
        if (obj.getFunctionAggregation() != null) {
            com.azure.search.documents.indexes.implementation.models.ScoringFunctionAggregation functionAggregation = ScoringFunctionAggregationConverter.map(obj.getFunctionAggregation());
            scoringProfile.setFunctionAggregation(functionAggregation);
        }
        return scoringProfile;
    }

    private ScoringProfileConverter() {
    }
}

