/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.search.documents.implementation.converters.TokenCharacterKindConverter;
import com.azure.search.documents.indexes.implementation.models.TokenCharacterKind;
import com.azure.search.documents.indexes.models.NGramTokenizer;
import java.util.List;
import java.util.stream.Collectors;

public final class NGramTokenizerConverter {
    public static NGramTokenizer map(com.azure.search.documents.indexes.implementation.models.NGramTokenizer obj) {
        if (obj == null) {
            return null;
        }
        NGramTokenizer nGramTokenizer = new NGramTokenizer(obj.getName());
        Integer maxGram = obj.getMaxGram();
        nGramTokenizer.setMaxGram(maxGram);
        if (obj.getTokenChars() != null) {
            nGramTokenizer.setTokenChars(obj.getTokenChars().stream().map(TokenCharacterKindConverter::map).collect(Collectors.toList()));
        }
        Integer minGram = obj.getMinGram();
        nGramTokenizer.setMinGram(minGram);
        return nGramTokenizer;
    }

    public static com.azure.search.documents.indexes.implementation.models.NGramTokenizer map(NGramTokenizer obj) {
        if (obj == null) {
            return null;
        }
        com.azure.search.documents.indexes.implementation.models.NGramTokenizer nGramTokenizer = new com.azure.search.documents.indexes.implementation.models.NGramTokenizer(obj.getName());
        Integer maxGram = obj.getMaxGram();
        nGramTokenizer.setMaxGram(maxGram);
        if (obj.getTokenChars() != null) {
            List<TokenCharacterKind> tokenChars = obj.getTokenChars().stream().map(TokenCharacterKindConverter::map).collect(Collectors.toList());
            nGramTokenizer.setTokenChars(tokenChars);
        }
        Integer minGram = obj.getMinGram();
        nGramTokenizer.setMinGram(minGram);
        nGramTokenizer.validate();
        return nGramTokenizer;
    }

    private NGramTokenizerConverter() {
    }
}

