/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.search.documents.implementation.util.PrivateFieldAccessHelper;
import com.azure.search.documents.indexes.implementation.models.KeywordTokenizer;
import com.azure.search.documents.indexes.implementation.models.KeywordTokenizerV2;
import com.azure.search.documents.indexes.implementation.models.LexicalTokenizer;

public final class KeywordTokenizerConverter {
    private static final String V1_ODATA_TYPE = "#Microsoft.Azure.Search.KeywordTokenizer";
    private static final String V2_ODATA_TYPE = "#Microsoft.Azure.Search.KeywordTokenizerV2";
    private static final String ODATA_FIELD_NAME = "odataType";

    public static com.azure.search.documents.indexes.models.KeywordTokenizer map(KeywordTokenizerV2 obj) {
        if (obj == null) {
            return null;
        }
        com.azure.search.documents.indexes.models.KeywordTokenizer keywordTokenizer = new com.azure.search.documents.indexes.models.KeywordTokenizer(obj.getName());
        PrivateFieldAccessHelper.set(keywordTokenizer, ODATA_FIELD_NAME, V2_ODATA_TYPE);
        Integer maxTokenLength = obj.getMaxTokenLength();
        keywordTokenizer.setMaxTokenLength(maxTokenLength);
        return keywordTokenizer;
    }

    public static com.azure.search.documents.indexes.models.KeywordTokenizer map(KeywordTokenizer obj) {
        if (obj == null) {
            return null;
        }
        com.azure.search.documents.indexes.models.KeywordTokenizer keywordTokenizer = new com.azure.search.documents.indexes.models.KeywordTokenizer(obj.getName());
        PrivateFieldAccessHelper.set(keywordTokenizer, ODATA_FIELD_NAME, V1_ODATA_TYPE);
        Integer bufferSize = obj.getBufferSize();
        keywordTokenizer.setMaxTokenLength(bufferSize);
        return keywordTokenizer;
    }

    public static LexicalTokenizer map(com.azure.search.documents.indexes.models.KeywordTokenizer obj) {
        if (obj == null) {
            return null;
        }
        String identifier = PrivateFieldAccessHelper.get(obj, ODATA_FIELD_NAME, String.class);
        if (V1_ODATA_TYPE.equals(identifier)) {
            return new KeywordTokenizer(obj.getName()).setBufferSize(obj.getMaxTokenLength());
        }
        return new KeywordTokenizerV2(obj.getName()).setMaxTokenLength(obj.getMaxTokenLength());
    }

    private KeywordTokenizerConverter() {
    }
}

