/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.search.documents.implementation.converters.IndexActionTypeConverter;
import com.azure.search.documents.implementation.models.IndexAction;
import com.azure.search.documents.implementation.util.PrivateFieldAccessHelper;
import com.azure.search.documents.implementation.util.Utility;
import com.azure.search.documents.models.IndexActionType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public final class IndexActionConverter {
    private static final ClientLogger LOGGER = new ClientLogger(IndexActionConverter.class);
    private static final JacksonAdapter searchJacksonAdapter = (JacksonAdapter)Utility.initializeSerializerAdapter();

    public static <T> com.azure.search.documents.models.IndexAction<T> map(IndexAction obj) {
        if (obj == null) {
            return null;
        }
        com.azure.search.documents.models.IndexAction indexAction = new com.azure.search.documents.models.IndexAction();
        if (obj.getActionType() != null) {
            IndexActionType actionType = IndexActionTypeConverter.map(obj.getActionType());
            indexAction.setActionType(actionType);
        }
        if (obj.getAdditionalProperties() != null) {
            Map<String, Object> properties = obj.getAdditionalProperties();
            PrivateFieldAccessHelper.set(indexAction, "properties", properties);
        }
        return indexAction;
    }

    public static <T> IndexAction map(com.azure.search.documents.models.IndexAction<T> obj, ObjectSerializer serializer) {
        Map mapProperties;
        if (obj == null) {
            return null;
        }
        IndexAction indexAction = new IndexAction();
        if (obj.getActionType() != null) {
            com.azure.search.documents.implementation.models.IndexActionType actionType = IndexActionTypeConverter.map(obj.getActionType());
            indexAction.setActionType(actionType);
        }
        if ((mapProperties = PrivateFieldAccessHelper.get(obj, "properties", Map.class)) == null) {
            T properties = obj.getDocument();
            if (serializer == null) {
                try {
                    String serializedJson = searchJacksonAdapter.serialize(properties, SerializerEncoding.JSON);
                    mapProperties = (Map)searchJacksonAdapter.deserialize(serializedJson, Utility.MAP_STRING_OBJECT_TYPE_REFERENCE.getJavaType(), SerializerEncoding.JSON);
                }
                catch (IOException ex) {
                    throw LOGGER.logExceptionAsError(new RuntimeException("Something wrong with the serialization."));
                }
            } else {
                ByteArrayOutputStream sourceStream = new ByteArrayOutputStream();
                serializer.serialize((OutputStream)sourceStream, properties);
                mapProperties = (Map)serializer.deserialize((InputStream)new ByteArrayInputStream(sourceStream.toByteArray()), Utility.MAP_STRING_OBJECT_TYPE_REFERENCE);
            }
        }
        indexAction.setAdditionalProperties(mapProperties);
        return indexAction;
    }

    private IndexActionConverter() {
    }
}

