/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation.converters;

import com.azure.search.documents.implementation.converters.CharFilterNameConverter;
import com.azure.search.documents.implementation.converters.LexicalAnalyzerNameConverter;
import com.azure.search.documents.implementation.converters.LexicalTokenizerNameConverter;
import com.azure.search.documents.implementation.converters.TokenFilterNameConverter;
import com.azure.search.documents.indexes.implementation.models.AnalyzeRequest;
import com.azure.search.documents.indexes.implementation.models.LexicalAnalyzerName;
import com.azure.search.documents.indexes.implementation.models.LexicalTokenizerName;
import com.azure.search.documents.indexes.models.AnalyzeTextOptions;
import com.azure.search.documents.indexes.models.CharFilterName;
import com.azure.search.documents.indexes.models.TokenFilterName;
import java.util.List;
import java.util.stream.Collectors;

public final class AnalyzeRequestConverter {
    public static AnalyzeTextOptions map(AnalyzeRequest obj) {
        if (obj == null) {
            return null;
        }
        AnalyzeTextOptions analyzeTextOptions = null;
        if (obj.getTokenizer() != null) {
            com.azure.search.documents.indexes.models.LexicalTokenizerName tokenizer = LexicalTokenizerNameConverter.map(obj.getTokenizer());
            analyzeTextOptions = new AnalyzeTextOptions(obj.getText(), tokenizer);
        } else {
            com.azure.search.documents.indexes.models.LexicalAnalyzerName analyzer = LexicalAnalyzerNameConverter.map(obj.getAnalyzer());
            analyzeTextOptions = new AnalyzeTextOptions(obj.getText(), analyzer);
        }
        if (obj.getCharFilters() != null) {
            analyzeTextOptions.setCharFilters((CharFilterName[])obj.getCharFilters().stream().map(CharFilterNameConverter::map).toArray(CharFilterName[]::new));
        }
        if (obj.getTokenFilters() != null) {
            analyzeTextOptions.setTokenFilters((TokenFilterName[])obj.getTokenFilters().stream().map(TokenFilterNameConverter::map).toArray(TokenFilterName[]::new));
        }
        return analyzeTextOptions;
    }

    public static AnalyzeRequest map(AnalyzeTextOptions obj) {
        if (obj == null) {
            return null;
        }
        AnalyzeRequest analyzeRequest = new AnalyzeRequest(obj.getText());
        if (obj.getCharFilters() != null) {
            List<com.azure.search.documents.indexes.implementation.models.CharFilterName> charFilters = obj.getCharFilters().stream().map(CharFilterNameConverter::map).collect(Collectors.toList());
            analyzeRequest.setCharFilters(charFilters);
        }
        if (obj.getAnalyzerName() != null) {
            LexicalAnalyzerName analyzer = LexicalAnalyzerNameConverter.map(obj.getAnalyzerName());
            analyzeRequest.setAnalyzer(analyzer);
        }
        if (obj.getTokenFilters() != null) {
            List<com.azure.search.documents.indexes.implementation.models.TokenFilterName> tokenFilters = obj.getTokenFilters().stream().map(TokenFilterNameConverter::map).collect(Collectors.toList());
            analyzeRequest.setTokenFilters(tokenFilters);
        }
        if (obj.getTokenizerName() != null) {
            LexicalTokenizerName tokenizer = LexicalTokenizerNameConverter.map(obj.getTokenizerName());
            analyzeRequest.setTokenizer(tokenizer);
        }
        analyzeRequest.validate();
        return analyzeRequest;
    }

    private AnalyzeRequestConverter() {
    }
}

