/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents.implementation;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.search.documents.implementation.SearchIndexClientImpl;

@ServiceClientBuilder(serviceClients={SearchIndexClientImpl.class})
public final class SearchIndexClientImplBuilder {
    private String endpoint;
    private String indexName;
    private HttpPipeline pipeline;
    private SerializerAdapter serializerAdapter;

    public SearchIndexClientImplBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public SearchIndexClientImplBuilder indexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public SearchIndexClientImplBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public SearchIndexClientImplBuilder serializerAdapter(SerializerAdapter serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        return this;
    }

    public SearchIndexClientImpl buildClient() {
        if (this.pipeline == null) {
            this.pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build();
        }
        if (this.serializerAdapter == null) {
            this.serializerAdapter = JacksonAdapter.createDefaultSerializerAdapter();
        }
        SearchIndexClientImpl client = new SearchIndexClientImpl(this.pipeline, this.serializerAdapter, this.endpoint, this.indexName);
        return client;
    }
}

