/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.search.documents.SearchAsyncClient;
import com.azure.search.documents.SearchClient;
import com.azure.search.documents.SearchServiceVersion;
import com.azure.search.documents.implementation.util.Constants;
import com.azure.search.documents.implementation.util.Utility;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={SearchClient.class, SearchAsyncClient.class})
public final class SearchClientBuilder {
    private final ClientLogger logger = new ClientLogger(SearchClientBuilder.class);
    private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
    private AzureKeyCredential credential;
    private SearchServiceVersion serviceVersion;
    private String endpoint;
    private HttpClient httpClient;
    private HttpPipeline httpPipeline;
    private HttpLogOptions httpLogOptions;
    private Configuration configuration;
    private String indexName;
    private RetryPolicy retryPolicy;
    private JsonSerializer jsonSerializer;

    public SearchClient buildClient() {
        return new SearchClient(this.buildAsyncClient());
    }

    public SearchAsyncClient buildAsyncClient() {
        SearchServiceVersion buildVersion;
        Objects.requireNonNull(this.indexName, "'indexName' cannot be null.");
        Objects.requireNonNull(this.endpoint, "'endpoint' cannot be null.");
        SearchServiceVersion searchServiceVersion = buildVersion = this.serviceVersion == null ? SearchServiceVersion.getLatest() : this.serviceVersion;
        if (this.httpPipeline != null) {
            return new SearchAsyncClient(this.endpoint, this.indexName, buildVersion, this.httpPipeline, this.jsonSerializer);
        }
        Objects.requireNonNull(this.credential, "'credential' cannot be null.");
        HttpPipeline pipeline = Utility.buildHttpPipeline(this.httpLogOptions, this.configuration, this.retryPolicy, this.credential, this.policies, this.httpClient);
        return new SearchAsyncClient(this.endpoint, this.indexName, buildVersion, pipeline, this.jsonSerializer);
    }

    public SearchClientBuilder endpoint(String endpoint) {
        try {
            new URL(endpoint);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL"));
        }
        this.endpoint = endpoint;
        return this;
    }

    public SearchClientBuilder credential(AzureKeyCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.credential = credential;
        return this;
    }

    public SearchClientBuilder indexName(String indexName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)indexName)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'indexName' cannot be null or empty."));
        }
        this.indexName = indexName;
        return this;
    }

    public SearchClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public static HttpLogOptions getDefaultLogOptions() {
        return Constants.DEFAULT_LOG_OPTIONS_SUPPLIER.get();
    }

    public SearchClientBuilder addPolicy(HttpPipelinePolicy policy) {
        this.policies.add(Objects.requireNonNull(policy));
        return this;
    }

    public SearchClientBuilder serializer(JsonSerializer jsonSerializer) {
        this.jsonSerializer = jsonSerializer;
        return this;
    }

    public SearchClientBuilder httpClient(HttpClient client) {
        if (this.httpClient != null && client == null) {
            this.logger.info("HttpClient is being set to 'null' when it was previously configured.");
        }
        this.httpClient = client;
        return this;
    }

    public SearchClientBuilder pipeline(HttpPipeline httpPipeline) {
        if (this.httpPipeline != null && httpPipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public SearchClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public SearchClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public SearchClientBuilder serviceVersion(SearchServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }
}

