/*
 * Decompiled with CFR 0.152.
 */
package com.azure.search.documents;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.ServiceVersion;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.core.util.serializer.TypeReference;
import com.azure.search.documents.SearchServiceVersion;
import com.azure.search.documents.implementation.SearchIndexClientImpl;
import com.azure.search.documents.implementation.SearchIndexClientImplBuilder;
import com.azure.search.documents.implementation.converters.AutocompleteModeConverter;
import com.azure.search.documents.implementation.converters.FacetResultConverter;
import com.azure.search.documents.implementation.converters.IndexBatchBaseConverter;
import com.azure.search.documents.implementation.converters.IndexDocumentsResultConverter;
import com.azure.search.documents.implementation.converters.QueryTypeConverter;
import com.azure.search.documents.implementation.converters.SearchModeConverter;
import com.azure.search.documents.implementation.converters.SearchResultConverter;
import com.azure.search.documents.implementation.converters.SuggestResultConverter;
import com.azure.search.documents.implementation.models.AutocompleteRequest;
import com.azure.search.documents.implementation.models.IndexDocumentsResult;
import com.azure.search.documents.implementation.models.SearchContinuationToken;
import com.azure.search.documents.implementation.models.SearchDocumentsResult;
import com.azure.search.documents.implementation.models.SearchFirstPageResponseWrapper;
import com.azure.search.documents.implementation.models.SearchRequest;
import com.azure.search.documents.implementation.models.SuggestDocumentsResult;
import com.azure.search.documents.implementation.models.SuggestRequest;
import com.azure.search.documents.implementation.util.DocumentResponseConversions;
import com.azure.search.documents.implementation.util.MappingUtils;
import com.azure.search.documents.implementation.util.SuggestOptionsHandler;
import com.azure.search.documents.implementation.util.Utility;
import com.azure.search.documents.indexes.models.IndexDocumentsBatch;
import com.azure.search.documents.models.AutocompleteOptions;
import com.azure.search.documents.models.FacetResult;
import com.azure.search.documents.models.IndexAction;
import com.azure.search.documents.models.IndexActionType;
import com.azure.search.documents.models.IndexBatchException;
import com.azure.search.documents.models.IndexDocumentsOptions;
import com.azure.search.documents.models.ScoringParameter;
import com.azure.search.documents.models.SearchOptions;
import com.azure.search.documents.models.SearchResult;
import com.azure.search.documents.models.SuggestOptions;
import com.azure.search.documents.models.SuggestResult;
import com.azure.search.documents.util.AutocompletePagedFlux;
import com.azure.search.documents.util.AutocompletePagedResponse;
import com.azure.search.documents.util.SearchPagedFlux;
import com.azure.search.documents.util.SearchPagedResponse;
import com.azure.search.documents.util.SuggestPagedFlux;
import com.azure.search.documents.util.SuggestPagedResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class SearchAsyncClient {
    private static final int MULTI_STATUS_CODE = 207;
    private final SearchServiceVersion serviceVersion;
    private final String endpoint;
    private final String indexName;
    private final ClientLogger logger = new ClientLogger(SearchAsyncClient.class);
    private final SearchIndexClientImpl restClient;
    private final HttpPipeline httpPipeline;
    private final JsonSerializer serializer;
    private static final SerializerAdapter ADAPTER = Utility.initializeSerializerAdapter();

    SearchAsyncClient(String endpoint, String indexName, SearchServiceVersion serviceVersion, HttpPipeline httpPipeline, JsonSerializer serializer) {
        this.endpoint = endpoint;
        this.indexName = indexName;
        this.serviceVersion = serviceVersion;
        this.httpPipeline = httpPipeline;
        this.serializer = serializer;
        this.restClient = new SearchIndexClientImplBuilder().endpoint(endpoint).indexName(indexName).pipeline(httpPipeline).serializerAdapter(ADAPTER).buildClient();
    }

    public String getIndexName() {
        return this.indexName;
    }

    HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Mono<com.azure.search.documents.models.IndexDocumentsResult> uploadDocuments(Iterable<?> documents) {
        return this.uploadDocumentsWithResponse(documents, null).map(Response::getValue);
    }

    public Mono<Response<com.azure.search.documents.models.IndexDocumentsResult>> uploadDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options) {
        return FluxUtil.withContext(context -> this.uploadDocumentsWithResponse(documents, options, (Context)context));
    }

    Mono<Response<com.azure.search.documents.models.IndexDocumentsResult>> uploadDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options, Context context) {
        return this.indexDocumentsWithResponse(SearchAsyncClient.buildIndexBatch(documents, IndexActionType.UPLOAD), options, context);
    }

    public Mono<com.azure.search.documents.models.IndexDocumentsResult> mergeDocuments(Iterable<?> documents) {
        return this.mergeDocumentsWithResponse(documents, null).map(Response::getValue);
    }

    public Mono<Response<com.azure.search.documents.models.IndexDocumentsResult>> mergeDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options) {
        return FluxUtil.withContext(context -> this.mergeDocumentsWithResponse(documents, options, (Context)context));
    }

    Mono<Response<com.azure.search.documents.models.IndexDocumentsResult>> mergeDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options, Context context) {
        return this.indexDocumentsWithResponse(SearchAsyncClient.buildIndexBatch(documents, IndexActionType.MERGE), options, context);
    }

    public Mono<com.azure.search.documents.models.IndexDocumentsResult> mergeOrUploadDocuments(Iterable<?> documents) {
        return this.mergeOrUploadDocumentsWithResponse(documents, null).map(Response::getValue);
    }

    public Mono<Response<com.azure.search.documents.models.IndexDocumentsResult>> mergeOrUploadDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options) {
        return FluxUtil.withContext(context -> this.mergeOrUploadDocumentsWithResponse(documents, options, (Context)context));
    }

    Mono<Response<com.azure.search.documents.models.IndexDocumentsResult>> mergeOrUploadDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options, Context context) {
        return this.indexDocumentsWithResponse(SearchAsyncClient.buildIndexBatch(documents, IndexActionType.MERGE_OR_UPLOAD), options, context);
    }

    public Mono<com.azure.search.documents.models.IndexDocumentsResult> deleteDocuments(Iterable<?> documents) {
        return this.deleteDocumentsWithResponse(documents, null).map(Response::getValue);
    }

    public Mono<Response<com.azure.search.documents.models.IndexDocumentsResult>> deleteDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options) {
        return FluxUtil.withContext(context -> this.deleteDocumentsWithResponse(documents, options, (Context)context));
    }

    Mono<Response<com.azure.search.documents.models.IndexDocumentsResult>> deleteDocumentsWithResponse(Iterable<?> documents, IndexDocumentsOptions options, Context context) {
        return this.indexDocumentsWithResponse(SearchAsyncClient.buildIndexBatch(documents, IndexActionType.DELETE), options, context);
    }

    public Mono<com.azure.search.documents.models.IndexDocumentsResult> indexDocuments(IndexDocumentsBatch<?> batch) {
        return this.indexDocumentsWithResponse(batch, null).map(Response::getValue);
    }

    public Mono<Response<com.azure.search.documents.models.IndexDocumentsResult>> indexDocumentsWithResponse(IndexDocumentsBatch<?> batch, IndexDocumentsOptions options) {
        return FluxUtil.withContext(context -> this.indexDocumentsWithResponse(batch, options, (Context)context));
    }

    Mono<Response<com.azure.search.documents.models.IndexDocumentsResult>> indexDocumentsWithResponse(IndexDocumentsBatch<?> batch, IndexDocumentsOptions options, Context context) {
        try {
            IndexDocumentsOptions documentsOptions = options == null ? new IndexDocumentsOptions() : options;
            return this.restClient.getDocuments().indexWithResponseAsync(IndexBatchBaseConverter.map(batch, (ObjectSerializer)this.serializer), null, context).onErrorMap(MappingUtils::exceptionMapper).flatMap(response -> response.getStatusCode() == 207 && documentsOptions.throwOnAnyError() ? Mono.error((Throwable)((Object)new IndexBatchException(IndexDocumentsResultConverter.map((IndexDocumentsResult)response.getValue())))) : Mono.just((Object)response).map(MappingUtils::mappingIndexDocumentResultResponse));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public <T> Mono<T> getDocument(String key, Class<T> modelClass) {
        return this.getDocumentWithResponse(key, modelClass, null).map(Response::getValue);
    }

    public <T> Mono<Response<T>> getDocumentWithResponse(String key, Class<T> modelClass, List<String> selectedFields) {
        return FluxUtil.withContext(context -> this.getDocumentWithResponse(key, modelClass, selectedFields, (Context)context));
    }

    <T> Mono<Response<T>> getDocumentWithResponse(String key, Class<T> modelClass, List<String> selectedFields, Context context) {
        try {
            return this.restClient.getDocuments().getWithResponseAsync(key, selectedFields, null, context).onErrorMap(DocumentResponseConversions::exceptionMapper).map(res -> {
                if (this.serializer == null) {
                    try {
                        String serializedJson = ADAPTER.serialize(res.getValue(), SerializerEncoding.JSON);
                        Object document = ADAPTER.deserialize(serializedJson, (Type)modelClass, SerializerEncoding.JSON);
                        return new SimpleResponse(res, document);
                    }
                    catch (IOException ex) {
                        throw this.logger.logExceptionAsError(new RuntimeException("Something wrong with the serialization."));
                    }
                }
                ByteArrayOutputStream sourceStream = new ByteArrayOutputStream();
                this.serializer.serialize((OutputStream)sourceStream, res.getValue());
                Object doc = this.serializer.deserialize((InputStream)new ByteArrayInputStream(sourceStream.toByteArray()), TypeReference.createInstance((Class)modelClass));
                return new SimpleResponse(res, doc);
            }).map(Function.identity());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Long> getDocumentCount() {
        return this.getDocumentCountWithResponse().map(Response::getValue);
    }

    public Mono<Response<Long>> getDocumentCountWithResponse() {
        return FluxUtil.withContext(this::getDocumentCountWithResponse);
    }

    Mono<Response<Long>> getDocumentCountWithResponse(Context context) {
        try {
            return this.restClient.getDocuments().countWithResponseAsync(null, context).onErrorMap(MappingUtils::exceptionMapper).map(Function.identity());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public SearchPagedFlux search(String searchText) {
        return this.search(searchText, null);
    }

    public SearchPagedFlux search(String searchText, SearchOptions searchOptions) {
        SearchRequest request = SearchAsyncClient.createSearchRequest(searchText, searchOptions);
        SearchFirstPageResponseWrapper firstPageResponse = new SearchFirstPageResponseWrapper();
        Function<String, Mono<SearchPagedResponse>> func = continuationToken -> FluxUtil.withContext(context -> this.search(request, (String)continuationToken, firstPageResponse, (Context)context));
        return new SearchPagedFlux(() -> (Mono)func.apply(null), func);
    }

    SearchPagedFlux search(String searchText, SearchOptions searchOptions, Context context) {
        SearchRequest request = SearchAsyncClient.createSearchRequest(searchText, searchOptions);
        SearchFirstPageResponseWrapper firstPageResponseWrapper = new SearchFirstPageResponseWrapper();
        Function<String, Mono<SearchPagedResponse>> func = continuationToken -> this.search(request, (String)continuationToken, firstPageResponseWrapper, context);
        return new SearchPagedFlux(() -> (Mono)func.apply(null), func);
    }

    private Mono<SearchPagedResponse> search(SearchRequest request, String continuationToken, SearchFirstPageResponseWrapper firstPageResponseWrapper, Context context) {
        if (continuationToken == null && firstPageResponseWrapper.getFirstPageResponse() != null) {
            return Mono.just((Object)((Object)firstPageResponseWrapper.getFirstPageResponse()));
        }
        SearchRequest requestToUse = continuationToken == null ? request : SearchContinuationToken.deserializeToken(this.serviceVersion.getVersion(), continuationToken);
        return this.restClient.getDocuments().searchPostWithResponseAsync(requestToUse, null, context).onErrorMap(MappingUtils::exceptionMapper).map(response -> {
            SearchDocumentsResult result = (SearchDocumentsResult)response.getValue();
            SearchPagedResponse page = new SearchPagedResponse((Response<List<SearchResult>>)new SimpleResponse(response, this.getSearchResults(result)), SearchAsyncClient.createContinuationToken(result, this.serviceVersion), SearchAsyncClient.getFacets(result), result.getCount(), result.getCoverage());
            if (continuationToken == null) {
                firstPageResponseWrapper.setFirstPageResponse(page);
            }
            return page;
        });
    }

    private List<SearchResult> getSearchResults(SearchDocumentsResult result) {
        return result.getResults().stream().map(searchResult -> SearchResultConverter.map(searchResult, (ObjectSerializer)this.serializer)).collect(Collectors.toList());
    }

    private static String createContinuationToken(SearchDocumentsResult result, ServiceVersion serviceVersion) {
        return SearchContinuationToken.serializeToken(serviceVersion.getVersion(), result.getNextLink(), result.getNextPageParameters());
    }

    private static Map<String, List<FacetResult>> getFacets(SearchDocumentsResult result) {
        if (result.getFacets() == null) {
            return null;
        }
        HashMap<String, List<FacetResult>> facets = new HashMap<String, List<FacetResult>>();
        result.getFacets().forEach((key, values) -> facets.put((String)key, values.stream().map(FacetResultConverter::map).collect(Collectors.toList())));
        return facets;
    }

    public SuggestPagedFlux suggest(String searchText, String suggesterName) {
        return this.suggest(searchText, suggesterName, null);
    }

    public SuggestPagedFlux suggest(String searchText, String suggesterName, SuggestOptions suggestOptions) {
        SuggestRequest suggestRequest = SearchAsyncClient.createSuggestRequest(searchText, suggesterName, SuggestOptionsHandler.ensureSuggestOptions(suggestOptions));
        return new SuggestPagedFlux(() -> FluxUtil.withContext(context -> this.suggest(suggestRequest, (Context)context)));
    }

    SuggestPagedFlux suggest(String searchText, String suggesterName, SuggestOptions suggestOptions, Context context) {
        SuggestRequest suggestRequest = SearchAsyncClient.createSuggestRequest(searchText, suggesterName, SuggestOptionsHandler.ensureSuggestOptions(suggestOptions));
        return new SuggestPagedFlux(() -> this.suggest(suggestRequest, context));
    }

    private Mono<SuggestPagedResponse> suggest(SuggestRequest suggestRequest, Context context) {
        return this.restClient.getDocuments().suggestPostWithResponseAsync(suggestRequest, null, context).onErrorMap(MappingUtils::exceptionMapper).map(response -> {
            SuggestDocumentsResult result = (SuggestDocumentsResult)response.getValue();
            return new SuggestPagedResponse((Response<List<SuggestResult>>)new SimpleResponse(response, SearchAsyncClient.getSuggestResults(result)), result.getCoverage());
        });
    }

    private static List<SuggestResult> getSuggestResults(SuggestDocumentsResult result) {
        return result.getResults().stream().map(SuggestResultConverter::map).collect(Collectors.toList());
    }

    public AutocompletePagedFlux autocomplete(String searchText, String suggesterName) {
        return this.autocomplete(searchText, suggesterName, null);
    }

    public AutocompletePagedFlux autocomplete(String searchText, String suggesterName, AutocompleteOptions autocompleteOptions) {
        AutocompleteRequest request = SearchAsyncClient.createAutoCompleteRequest(searchText, suggesterName, autocompleteOptions);
        return new AutocompletePagedFlux(() -> FluxUtil.withContext(context -> this.autocomplete(request, (Context)context)));
    }

    AutocompletePagedFlux autocomplete(String searchText, String suggesterName, AutocompleteOptions autocompleteOptions, Context context) {
        AutocompleteRequest request = SearchAsyncClient.createAutoCompleteRequest(searchText, suggesterName, autocompleteOptions);
        return new AutocompletePagedFlux(() -> this.autocomplete(request, context));
    }

    private Mono<AutocompletePagedResponse> autocomplete(AutocompleteRequest request, Context context) {
        return this.restClient.getDocuments().autocompletePostWithResponseAsync(request, null, context).onErrorMap(MappingUtils::exceptionMapper).map(MappingUtils::mappingAutocompleteResponse);
    }

    private static SearchRequest createSearchRequest(String searchText, SearchOptions searchOptions) {
        SearchRequest searchRequest = new SearchRequest().setSearchText(searchText);
        if (searchOptions != null) {
            List<String> scoringParameters = searchOptions.getScoringParameters() == null ? null : searchOptions.getScoringParameters().stream().map(ScoringParameter::toString).collect(Collectors.toList());
            searchRequest.setSearchMode(SearchModeConverter.map(searchOptions.getSearchMode())).setFacets(searchOptions.getFacets()).setFilter(searchOptions.getFilter()).setHighlightPostTag(searchOptions.getHighlightPostTag()).setHighlightPreTag(searchOptions.getHighlightPreTag()).setIncludeTotalResultCount(searchOptions.isTotalCountIncluded()).setMinimumCoverage(searchOptions.getMinimumCoverage()).setQueryType(QueryTypeConverter.map(searchOptions.getQueryType())).setScoringParameters(scoringParameters).setScoringProfile(searchOptions.getScoringProfile()).setSkip(searchOptions.getSkip()).setTop(searchOptions.getTop());
            if (searchOptions.getHighlightFields() != null) {
                searchRequest.setHighlightFields(String.join((CharSequence)",", searchOptions.getHighlightFields()));
            }
            if (searchOptions.getSearchFields() != null) {
                searchRequest.setSearchFields(String.join((CharSequence)",", searchOptions.getSearchFields()));
            }
            if (searchOptions.getOrderBy() != null) {
                searchRequest.setOrderBy(String.join((CharSequence)",", searchOptions.getOrderBy()));
            }
            if (searchOptions.getSelect() != null) {
                searchRequest.setSelect(String.join((CharSequence)",", searchOptions.getSelect()));
            }
        }
        return searchRequest;
    }

    private static SuggestRequest createSuggestRequest(String searchText, String suggesterName, SuggestOptions suggestOptions) {
        SuggestRequest suggestRequest = new SuggestRequest(searchText, suggesterName);
        suggestRequest.validate();
        if (suggestOptions != null) {
            List<String> select;
            List<String> orderBy;
            suggestRequest.setFilter(suggestOptions.getFilter()).setUseFuzzyMatching(suggestOptions.useFuzzyMatching()).setHighlightPostTag(suggestOptions.getHighlightPostTag()).setHighlightPreTag(suggestOptions.getHighlightPreTag()).setMinimumCoverage(suggestOptions.getMinimumCoverage()).setTop(suggestOptions.getTop());
            List<String> searchFields = suggestOptions.getSearchFields();
            if (searchFields != null) {
                suggestRequest.setSearchFields(String.join((CharSequence)",", searchFields));
            }
            if ((orderBy = suggestOptions.getOrderBy()) != null) {
                suggestRequest.setOrderBy(String.join((CharSequence)",", orderBy));
            }
            if ((select = suggestOptions.getSelect()) != null) {
                suggestRequest.setSelect(String.join((CharSequence)",", select));
            }
        }
        return suggestRequest;
    }

    private static AutocompleteRequest createAutoCompleteRequest(String searchText, String suggesterName, AutocompleteOptions autocompleteOptions) {
        AutocompleteRequest autoCompleteRequest = new AutocompleteRequest(searchText, suggesterName);
        autoCompleteRequest.validate();
        if (autocompleteOptions != null) {
            autoCompleteRequest.setFilter(autocompleteOptions.getFilter()).setUseFuzzyMatching(autocompleteOptions.useFuzzyMatching()).setHighlightPostTag(autocompleteOptions.getHighlightPostTag()).setHighlightPreTag(autocompleteOptions.getHighlightPreTag()).setMinimumCoverage(autocompleteOptions.getMinimumCoverage()).setTop(autocompleteOptions.getTop()).setAutocompleteMode(AutocompleteModeConverter.map(autocompleteOptions.getAutocompleteMode()));
            List<String> searchFields = autocompleteOptions.getSearchFields();
            if (searchFields != null) {
                autoCompleteRequest.setSearchFields(String.join((CharSequence)",", searchFields));
            }
        }
        return autoCompleteRequest;
    }

    private static <T> IndexDocumentsBatch<T> buildIndexBatch(Iterable<T> documents, IndexActionType actionType) {
        ArrayList actions = new ArrayList();
        documents.forEach(d -> actions.add(new IndexAction().setActionType(actionType).setDocument(d)));
        return new IndexDocumentsBatch().addActions(actions);
    }
}

