// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Defines values for TextSplitMode.
 */
public final class TextSplitMode extends ExpandableStringEnum<TextSplitMode> {
    /**
     * Static value pages for TextSplitMode.
     */
    public static final TextSplitMode PAGES = fromString("pages");

    /**
     * Static value sentences for TextSplitMode.
     */
    public static final TextSplitMode SENTENCES = fromString("sentences");

    /**
     * Creates or finds a TextSplitMode from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding TextSplitMode.
     */
    @JsonCreator
    public static TextSplitMode fromString(String name) {
        return fromString(name, TextSplitMode.class);
    }

    /**
     * @return known TextSplitMode values.
     */
    public static Collection<TextSplitMode> values() {
        return values(TextSplitMode.class);
    }
}
