// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The SearchResourceEncryptionKey model. */
@Fluent
public final class SearchResourceEncryptionKey {
    /*
     * The name of your Azure Key Vault key to be used to encrypt your data at
     * rest.
     */
    @JsonProperty(value = "keyVaultKeyName", required = true)
    private String keyName;

    /*
     * The version of your Azure Key Vault key to be used to encrypt your data
     * at rest.
     */
    @JsonProperty(value = "keyVaultKeyVersion", required = true)
    private String keyVersion;

    /*
     * The URI of your Azure Key Vault, also referred to as DNS name, that
     * contains the key to be used to encrypt your data at rest. An example URI
     * might be https://my-keyvault-name.vault.azure.net.
     */
    @JsonProperty(value = "keyVaultUri", required = true)
    private String vaultUri;

    /*
     * Optional Azure Active Directory credentials used for accessing your
     * Azure Key Vault. Not required if using managed identity instead.
     */
    @JsonProperty(value = "accessCredentials")
    private AzureActiveDirectoryApplicationCredentials accessCredentials;

    /** Creates an instance of SearchResourceEncryptionKey class. */
    @JsonCreator
    public SearchResourceEncryptionKey(
            @JsonProperty(value = "keyVaultKeyName") String keyName,
            @JsonProperty(value = "keyVaultKeyVersion") String keyVersion,
            @JsonProperty(value = "keyVaultUri") String vaultUri) {
        this.keyName = keyName;
        this.keyVersion = keyVersion;
        this.vaultUri = vaultUri;
    }

    /**
     * Get the keyName property: The name of your Azure Key Vault key to be used to encrypt your data at rest.
     *
     * @return the keyName value.
     */
    public String getKeyName() {
        return this.keyName;
    }

    /**
     * Set the keyName property: The name of your Azure Key Vault key to be used to encrypt your data at rest.
     *
     * @param keyName the keyName value to set.
     * @return the SearchResourceEncryptionKey object itself.
     */
    /**
     * Get the keyVersion property: The version of your Azure Key Vault key to be used to encrypt your data at rest.
     *
     * @return the keyVersion value.
     */
    public String getKeyVersion() {
        return this.keyVersion;
    }

    /**
     * Set the keyVersion property: The version of your Azure Key Vault key to be used to encrypt your data at rest.
     *
     * @param keyVersion the keyVersion value to set.
     * @return the SearchResourceEncryptionKey object itself.
     */
    /**
     * Get the vaultUri property: The URI of your Azure Key Vault, also referred to as DNS name, that contains the key
     * to be used to encrypt your data at rest. An example URI might be https://my-keyvault-name.vault.azure.net.
     *
     * @return the vaultUri value.
     */
    public String getVaultUri() {
        return this.vaultUri;
    }

    /**
     * Set the vaultUri property: The URI of your Azure Key Vault, also referred to as DNS name, that contains the key
     * to be used to encrypt your data at rest. An example URI might be https://my-keyvault-name.vault.azure.net.
     *
     * @param vaultUri the vaultUri value to set.
     * @return the SearchResourceEncryptionKey object itself.
     */
    /**
     * Get the accessCredentials property: Optional Azure Active Directory credentials used for accessing your Azure Key
     * Vault. Not required if using managed identity instead.
     *
     * @return the accessCredentials value.
     */
    public AzureActiveDirectoryApplicationCredentials getAccessCredentials() {
        return this.accessCredentials;
    }

    /**
     * Set the accessCredentials property: Optional Azure Active Directory credentials used for accessing your Azure Key
     * Vault. Not required if using managed identity instead.
     *
     * @param accessCredentials the accessCredentials value to set.
     * @return the SearchResourceEncryptionKey object itself.
     */
    public SearchResourceEncryptionKey setAccessCredentials(
            AzureActiveDirectoryApplicationCredentials accessCredentials) {
        this.accessCredentials = accessCredentials;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getKeyName() == null) {
            throw new IllegalArgumentException(
                    "Missing required property keyName in model SearchResourceEncryptionKey");
        }
        if (getKeyVersion() == null) {
            throw new IllegalArgumentException(
                    "Missing required property keyVersion in model SearchResourceEncryptionKey");
        }
        if (getVaultUri() == null) {
            throw new IllegalArgumentException(
                    "Missing required property vaultUri in model SearchResourceEncryptionKey");
        }
        if (getAccessCredentials() != null) {
            getAccessCredentials().validate();
        }
    }
}
