// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

/** The PatternCaptureTokenFilter model. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "@odata\\.type")
@JsonTypeName("#Microsoft.Azure.Search.PatternCaptureTokenFilter")
@JsonFlatten
@Fluent
public class PatternCaptureTokenFilter extends TokenFilter {
    /*
     * A list of patterns to match against each token.
     */
    @JsonProperty(value = "patterns", required = true)
    private List<String> patterns;

    /*
     * A value indicating whether to return the original token even if one of
     * the patterns matches. Default is true.
     */
    @JsonProperty(value = "preserveOriginal")
    private Boolean preserveOriginal;

    /** Creates an instance of PatternCaptureTokenFilter class. */
    @JsonCreator
    public PatternCaptureTokenFilter(
            @JsonProperty(value = "name") String name, @JsonProperty(value = "patterns") List<String> patterns) {
        super(name);
        this.patterns = patterns;
    }

    /**
     * Get the patterns property: A list of patterns to match against each token.
     *
     * @return the patterns value.
     */
    public List<String> getPatterns() {
        return this.patterns;
    }

    /**
     * Set the patterns property: A list of patterns to match against each token.
     *
     * @param patterns the patterns value to set.
     * @return the PatternCaptureTokenFilter object itself.
     */
    /**
     * Get the preserveOriginal property: A value indicating whether to return the original token even if one of the
     * patterns matches. Default is true.
     *
     * @return the preserveOriginal value.
     */
    public Boolean isPreserveOriginal() {
        return this.preserveOriginal;
    }

    /**
     * Set the preserveOriginal property: A value indicating whether to return the original token even if one of the
     * patterns matches. Default is true.
     *
     * @param preserveOriginal the preserveOriginal value to set.
     * @return the PatternCaptureTokenFilter object itself.
     */
    public PatternCaptureTokenFilter setPreserveOriginal(Boolean preserveOriginal) {
        this.preserveOriginal = preserveOriginal;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (getPatterns() == null) {
            throw new IllegalArgumentException("Missing required property patterns in model PatternCaptureTokenFilter");
        }
    }
}
