// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The ListIndexesResult model. */
@Immutable
public final class ListIndexesResult {
    /*
     * The indexes in the Search service.
     */
    @JsonProperty(value = "value", required = true, access = JsonProperty.Access.WRITE_ONLY)
    private List<SearchIndex> indexes;

    /** Creates an instance of ListIndexesResult class. */
    @JsonCreator
    public ListIndexesResult(@JsonProperty(value = "value") List<SearchIndex> indexes) {
        this.indexes = indexes;
    }

    /**
     * Get the indexes property: The indexes in the Search service.
     *
     * @return the indexes value.
     */
    public List<SearchIndex> getIndexes() {
        return this.indexes;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getIndexes() != null) {
            getIndexes().forEach(e -> e.validate());
        }
    }
}
