// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The InputFieldMappingEntry model. */
@Fluent
public final class InputFieldMappingEntry {
    /*
     * The name of the input.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * The source of the input.
     */
    @JsonProperty(value = "source")
    private String source;

    /*
     * The source context used for selecting recursive inputs.
     */
    @JsonProperty(value = "sourceContext")
    private String sourceContext;

    /*
     * The recursive inputs used when creating a complex type.
     */
    @JsonProperty(value = "inputs")
    private List<InputFieldMappingEntry> inputs;

    /** Creates an instance of InputFieldMappingEntry class. */
    @JsonCreator
    public InputFieldMappingEntry(@JsonProperty(value = "name") String name) {
        this.name = name;
    }

    /**
     * Get the name property: The name of the input.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: The name of the input.
     *
     * @param name the name value to set.
     * @return the InputFieldMappingEntry object itself.
     */
    /**
     * Get the source property: The source of the input.
     *
     * @return the source value.
     */
    public String getSource() {
        return this.source;
    }

    /**
     * Set the source property: The source of the input.
     *
     * @param source the source value to set.
     * @return the InputFieldMappingEntry object itself.
     */
    public InputFieldMappingEntry setSource(String source) {
        this.source = source;
        return this;
    }

    /**
     * Get the sourceContext property: The source context used for selecting recursive inputs.
     *
     * @return the sourceContext value.
     */
    public String getSourceContext() {
        return this.sourceContext;
    }

    /**
     * Set the sourceContext property: The source context used for selecting recursive inputs.
     *
     * @param sourceContext the sourceContext value to set.
     * @return the InputFieldMappingEntry object itself.
     */
    public InputFieldMappingEntry setSourceContext(String sourceContext) {
        this.sourceContext = sourceContext;
        return this;
    }

    /**
     * Get the inputs property: The recursive inputs used when creating a complex type.
     *
     * @return the inputs value.
     */
    public List<InputFieldMappingEntry> getInputs() {
        return this.inputs;
    }

    /**
     * Set the inputs property: The recursive inputs used when creating a complex type.
     *
     * @param inputs the inputs value to set.
     * @return the InputFieldMappingEntry object itself.
     */
    public InputFieldMappingEntry setInputs(List<InputFieldMappingEntry> inputs) {
        this.inputs = inputs;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getName() == null) {
            throw new IllegalArgumentException("Missing required property name in model InputFieldMappingEntry");
        }
        if (getInputs() != null) {
            getInputs().forEach(e -> e.validate());
        }
    }
}
