// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The DistanceScoringParameters model. */
@Fluent
public final class DistanceScoringParameters {
    /*
     * The name of the parameter passed in search queries to specify the
     * reference location.
     */
    @JsonProperty(value = "referencePointParameter", required = true)
    private String referencePointParameter;

    /*
     * The distance in kilometers from the reference location where the
     * boosting range ends.
     */
    @JsonProperty(value = "boostingDistance", required = true)
    private double boostingDistance;

    /** Creates an instance of DistanceScoringParameters class. */
    @JsonCreator
    public DistanceScoringParameters(
            @JsonProperty(value = "referencePointParameter") String referencePointParameter,
            @JsonProperty(value = "boostingDistance") double boostingDistance) {
        this.referencePointParameter = referencePointParameter;
        this.boostingDistance = boostingDistance;
    }

    /**
     * Get the referencePointParameter property: The name of the parameter passed in search queries to specify the
     * reference location.
     *
     * @return the referencePointParameter value.
     */
    public String getReferencePointParameter() {
        return this.referencePointParameter;
    }

    /**
     * Set the referencePointParameter property: The name of the parameter passed in search queries to specify the
     * reference location.
     *
     * @param referencePointParameter the referencePointParameter value to set.
     * @return the DistanceScoringParameters object itself.
     */
    /**
     * Get the boostingDistance property: The distance in kilometers from the reference location where the boosting
     * range ends.
     *
     * @return the boostingDistance value.
     */
    public double getBoostingDistance() {
        return this.boostingDistance;
    }

    /**
     * Set the boostingDistance property: The distance in kilometers from the reference location where the boosting
     * range ends.
     *
     * @param boostingDistance the boostingDistance value to set.
     * @return the DistanceScoringParameters object itself.
     */
    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getReferencePointParameter() == null) {
            throw new IllegalArgumentException(
                    "Missing required property referencePointParameter in model DistanceScoringParameters");
        }
    }
}
