// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

package com.azure.search.documents.indexes.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.JsonFlatten;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

/** The CommonGramTokenFilter model. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "@odata\\.type")
@JsonTypeName("#Microsoft.Azure.Search.CommonGramTokenFilter")
@JsonFlatten
@Fluent
public class CommonGramTokenFilter extends TokenFilter {
    /*
     * The set of common words.
     */
    @JsonProperty(value = "commonWords", required = true)
    private List<String> commonWords;

    /*
     * A value indicating whether common words matching will be case
     * insensitive. Default is false.
     */
    @JsonProperty(value = "ignoreCase")
    private Boolean ignoreCase;

    /*
     * A value that indicates whether the token filter is in query mode. When
     * in query mode, the token filter generates bigrams and then removes
     * common words and single terms followed by a common word. Default is
     * false.
     */
    @JsonProperty(value = "queryMode")
    private Boolean useQueryMode;

    /** Creates an instance of CommonGramTokenFilter class. */
    @JsonCreator
    public CommonGramTokenFilter(
            @JsonProperty(value = "name") String name, @JsonProperty(value = "commonWords") List<String> commonWords) {
        super(name);
        this.commonWords = commonWords;
    }

    /**
     * Get the commonWords property: The set of common words.
     *
     * @return the commonWords value.
     */
    public List<String> getCommonWords() {
        return this.commonWords;
    }

    /**
     * Set the commonWords property: The set of common words.
     *
     * @param commonWords the commonWords value to set.
     * @return the CommonGramTokenFilter object itself.
     */
    /**
     * Get the ignoreCase property: A value indicating whether common words matching will be case insensitive. Default
     * is false.
     *
     * @return the ignoreCase value.
     */
    public Boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    /**
     * Set the ignoreCase property: A value indicating whether common words matching will be case insensitive. Default
     * is false.
     *
     * @param ignoreCase the ignoreCase value to set.
     * @return the CommonGramTokenFilter object itself.
     */
    public CommonGramTokenFilter setIgnoreCase(Boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    /**
     * Get the useQueryMode property: A value that indicates whether the token filter is in query mode. When in query
     * mode, the token filter generates bigrams and then removes common words and single terms followed by a common
     * word. Default is false.
     *
     * @return the useQueryMode value.
     */
    public Boolean isUseQueryMode() {
        return this.useQueryMode;
    }

    /**
     * Set the useQueryMode property: A value that indicates whether the token filter is in query mode. When in query
     * mode, the token filter generates bigrams and then removes common words and single terms followed by a common
     * word. Default is false.
     *
     * @param useQueryMode the useQueryMode value to set.
     * @return the CommonGramTokenFilter object itself.
     */
    public CommonGramTokenFilter setUseQueryMode(Boolean useQueryMode) {
        this.useQueryMode = useQueryMode;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (getCommonWords() == null) {
            throw new IllegalArgumentException("Missing required property commonWords in model CommonGramTokenFilter");
        }
    }
}
