// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

package com.azure.search.documents.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** The IndexAction model. */
@Fluent
public final class IndexAction {
    /*
     * The operation to perform on a document in an indexing batch.
     */
    @JsonProperty(value = "@search.action")
    private IndexActionType actionType;

    /*
     * Represents an index action that operates on a document.
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the actionType property: The operation to perform on a document in an indexing batch.
     *
     * @return the actionType value.
     */
    public IndexActionType getActionType() {
        return this.actionType;
    }

    /**
     * Set the actionType property: The operation to perform on a document in an indexing batch.
     *
     * @param actionType the actionType value to set.
     * @return the IndexAction object itself.
     */
    public IndexAction setActionType(IndexActionType actionType) {
        this.actionType = actionType;
        return this;
    }

    /**
     * Get the additionalProperties property: Represents an index action that operates on a document.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: Represents an index action that operates on a document.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the IndexAction object itself.
     */
    public IndexAction setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void setAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {}
}
