/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.messaging.webpubsub.WebPubSubAuthenticationPolicy;
import com.azure.messaging.webpubsub.WebPubSubServiceClientBuilder;
import com.azure.messaging.webpubsub.implementation.WebPubSubUtil;
import com.azure.messaging.webpubsub.implementation.WebPubSubsImpl;
import com.azure.messaging.webpubsub.implementation.models.AddToGroupsRequest;
import com.azure.messaging.webpubsub.models.GetClientAccessTokenOptions;
import com.azure.messaging.webpubsub.models.WebPubSubClientAccessToken;
import com.azure.messaging.webpubsub.models.WebPubSubClientProtocol;
import com.azure.messaging.webpubsub.models.WebPubSubContentType;
import com.azure.messaging.webpubsub.models.WebPubSubGroupConnection;
import com.azure.messaging.webpubsub.models.WebPubSubPermission;
import java.util.List;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=WebPubSubServiceClientBuilder.class, isAsync=true)
public final class WebPubSubServiceAsyncClient {
    private final WebPubSubsImpl serviceClient;
    private final String hub;
    private final String endpoint;
    private final AzureKeyCredential keyCredential;

    WebPubSubServiceAsyncClient(WebPubSubsImpl serviceClient, String hub, String endpoint, AzureKeyCredential keyCredential) {
        this.serviceClient = serviceClient;
        this.hub = hub;
        this.endpoint = endpoint;
        this.keyCredential = keyCredential;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<WebPubSubClientAccessToken> getClientAccessToken(GetClientAccessTokenOptions options) {
        String path;
        WebPubSubClientProtocol webPubSubClientProtocol = options.getWebPubSubClientProtocol();
        switch (webPubSubClientProtocol.toString()) {
            case "mqtt": {
                path = "clients/mqtt/hubs/";
                break;
            }
            case "socketio": {
                path = "clients/socketio/hubs/";
                break;
            }
            default: {
                path = "client/hubs/";
            }
        }
        if (this.keyCredential == null) {
            return this.serviceClient.generateClientTokenWithResponseAsync(this.hub, WebPubSubServiceAsyncClient.configureClientAccessTokenRequestOptions(options)).map(response -> {
                String token = WebPubSubUtil.getToken((BinaryData)response.getValue());
                return WebPubSubUtil.createToken(token, this.endpoint, this.hub, path);
            });
        }
        return Mono.fromCallable(() -> {
            String audience = this.endpoint + (this.endpoint.endsWith("/") ? "" : "/") + path + this.hub;
            String token = WebPubSubAuthenticationPolicy.getAuthenticationToken(audience, options, this.keyCredential);
            return WebPubSubUtil.createToken(token, this.endpoint, this.hub, path);
        });
    }

    static RequestOptions configureClientAccessTokenRequestOptions(GetClientAccessTokenOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        if (options.getUserId() != null) {
            requestOptions.addQueryParam("userId", options.getUserId());
        }
        if (options.getExpiresAfter() != null) {
            requestOptions.addQueryParam("minutesToExpire", String.valueOf(options.getExpiresAfter().toMinutes()));
        }
        if (!CoreUtils.isNullOrEmpty(options.getRoles())) {
            options.getRoles().stream().forEach(roleName -> requestOptions.addQueryParam("role", roleName));
        }
        if (!CoreUtils.isNullOrEmpty(options.getGroups())) {
            options.getGroups().stream().forEach(groupName -> requestOptions.addQueryParam("group", groupName));
        }
        if (options.getWebPubSubClientProtocol() != null) {
            requestOptions.addQueryParam("clientType", options.getWebPubSubClientProtocol().toString());
        }
        return requestOptions;
    }

    Mono<Response<BinaryData>> generateClientTokenWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.generateClientTokenWithResponseAsync(this.hub, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendToAllWithResponse(BinaryData message, WebPubSubContentType contentType, long contentLength, RequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.setHeader(HttpHeaderName.CONTENT_TYPE, contentType.toString());
        requestOptions.setHeader(HttpHeaderName.CONTENT_LENGTH, String.valueOf(contentLength));
        return this.serviceClient.sendToAllWithResponseAsync(this.hub, "", message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendToAllWithResponse(BinaryData message, RequestOptions requestOptions) {
        return this.serviceClient.sendToAllWithResponseAsync(this.hub, "", message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> sendToAll(String message, WebPubSubContentType contentType) {
        return this.sendToAllWithResponse(BinaryData.fromString((String)message), new RequestOptions().setHeader(HttpHeaderName.CONTENT_TYPE, contentType.toString())).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> connectionExistsWithResponse(String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.connectionExistsWithResponseAsync(this.hub, connectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> closeConnectionWithResponse(String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.closeConnectionWithResponseAsync(this.hub, connectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendToConnectionWithResponse(String connectionId, BinaryData message, WebPubSubContentType contentType, long contentLength, RequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.setHeader(HttpHeaderName.CONTENT_TYPE, contentType.toString());
        requestOptions.setHeader(HttpHeaderName.CONTENT_LENGTH, String.valueOf(contentLength));
        return this.serviceClient.sendToConnectionWithResponseAsync(this.hub, connectionId, "", message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendToConnectionWithResponse(String connectionId, BinaryData message, RequestOptions requestOptions) {
        return this.serviceClient.sendToConnectionWithResponseAsync(this.hub, connectionId, "", message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> sendToConnection(String connectionId, String message, WebPubSubContentType contentType) {
        return this.sendToConnectionWithResponse(connectionId, BinaryData.fromString((String)message), new RequestOptions().setHeader(HttpHeaderName.CONTENT_TYPE, contentType.toString())).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> groupExistsWithResponse(String group, RequestOptions requestOptions) {
        return this.serviceClient.groupExistsWithResponseAsync(this.hub, group, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendToGroupWithResponse(String group, BinaryData message, WebPubSubContentType contentType, long contentLength, RequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.setHeader(HttpHeaderName.CONTENT_TYPE, contentType.toString());
        requestOptions.setHeader(HttpHeaderName.CONTENT_LENGTH, String.valueOf(contentLength));
        return this.serviceClient.sendToGroupWithResponseAsync(this.hub, group, "", message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendToGroupWithResponse(String group, BinaryData message, RequestOptions requestOptions) {
        return this.serviceClient.sendToGroupWithResponseAsync(this.hub, group, "", message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> sendToGroup(String group, String message, WebPubSubContentType contentType) {
        return this.sendToGroupWithResponse(group, BinaryData.fromString((String)message), new RequestOptions().setHeader(HttpHeaderName.CONTENT_TYPE, contentType.toString())).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addConnectionToGroupWithResponse(String group, String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.addConnectionToGroupWithResponseAsync(this.hub, group, connectionId, requestOptions);
    }

    private Mono<Response<Void>> addConnectionsToGroupsWithResponse(BinaryData groupsToAdd, RequestOptions requestOptions) {
        return this.serviceClient.addConnectionsToGroupsWithResponseAsync(this.hub, groupsToAdd, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> addConnectionsToGroups(List<String> groups, String filter) {
        AddToGroupsRequest requestBody = new AddToGroupsRequest();
        requestBody.setGroups(groups);
        requestBody.setFilter(filter);
        BinaryData body = BinaryData.fromObject((Object)requestBody);
        return this.addConnectionsToGroupsWithResponse(body, new RequestOptions()).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<WebPubSubGroupConnection> listConnectionsInGroup(String group, RequestOptions requestOptions) {
        PagedFlux<BinaryData> binaryDataPagedFlux = this.serviceClient.listConnectionsInGroupAsync(this.hub, group, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? binaryDataPagedFlux.byPage().take(1L) : binaryDataPagedFlux.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(bd -> (WebPubSubGroupConnection)bd.toObject(WebPubSubGroupConnection.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeConnectionFromGroupWithResponse(String group, String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.removeConnectionFromGroupWithResponseAsync(this.hub, group, connectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeConnectionFromAllGroupsWithResponse(String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.removeConnectionFromAllGroupsWithResponseAsync(this.hub, connectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> userExistsWithResponse(String userId, RequestOptions requestOptions) {
        return this.serviceClient.userExistsWithResponseAsync(this.hub, userId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendToUserWithResponse(String userId, BinaryData message, WebPubSubContentType contentType, long contentLength, RequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.setHeader(HttpHeaderName.CONTENT_TYPE, contentType.toString());
        requestOptions.setHeader(HttpHeaderName.CONTENT_LENGTH, String.valueOf(contentLength));
        return this.serviceClient.sendToUserWithResponseAsync(this.hub, userId, "", message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> sendToUserWithResponse(String userId, BinaryData message, RequestOptions requestOptions) {
        return this.serviceClient.sendToUserWithResponseAsync(this.hub, userId, "", message, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> sendToUser(String userId, String message, WebPubSubContentType contentType) {
        return this.sendToUserWithResponse(userId, BinaryData.fromString((String)message), new RequestOptions().setHeader(HttpHeaderName.CONTENT_TYPE, contentType.toString())).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> addUserToGroupWithResponse(String group, String userId, RequestOptions requestOptions) {
        return this.serviceClient.addUserToGroupWithResponseAsync(this.hub, group, userId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeUserFromGroupWithResponse(String group, String userId, RequestOptions requestOptions) {
        return this.serviceClient.removeUserFromGroupWithResponseAsync(this.hub, group, userId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeUserFromAllGroupsWithResponse(String userId, RequestOptions requestOptions) {
        return this.serviceClient.removeUserFromAllGroupsWithResponseAsync(this.hub, userId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> grantPermissionWithResponse(WebPubSubPermission permission, String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.grantPermissionWithResponseAsync(this.hub, permission.toString(), connectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> revokePermissionWithResponse(WebPubSubPermission permission, String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.revokePermissionWithResponseAsync(this.hub, permission.toString(), connectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> checkPermissionWithResponse(WebPubSubPermission permission, String connectionId, RequestOptions requestOptions) {
        return this.serviceClient.checkPermissionWithResponseAsync(this.hub, permission.toString(), connectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> closeAllConnectionsWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.closeAllConnectionsWithResponseAsync(this.hub, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> closeGroupConnectionsWithResponse(String group, RequestOptions requestOptions) {
        return this.serviceClient.closeGroupConnectionsWithResponseAsync(this.hub, group, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> closeUserConnectionsWithResponse(String userId, RequestOptions requestOptions) {
        return this.serviceClient.closeUserConnectionsWithResponseAsync(this.hub, userId, requestOptions);
    }
}

