/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.client.implementation.models;

import com.azure.core.util.BinaryData;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.webpubsub.client.implementation.models.WebPubSubMessage;
import com.azure.messaging.webpubsub.client.models.WebPubSubDataFormat;
import java.io.IOException;
import java.util.Base64;

public final class GroupDataMessage
extends WebPubSubMessage {
    private static final String TYPE = "message";
    private static final String FROM = "group";
    private final String group;
    private final WebPubSubDataFormat dataType;
    private final BinaryData data;
    private final String fromUserId;
    private final Long sequenceId;

    public GroupDataMessage(String group, WebPubSubDataFormat dataType, BinaryData data, String fromUserId, Long sequenceId) {
        this.data = data;
        this.dataType = dataType;
        this.fromUserId = fromUserId;
        this.group = group;
        this.sequenceId = sequenceId;
    }

    public BinaryData getData() {
        return this.data;
    }

    public WebPubSubDataFormat getDataType() {
        return this.dataType;
    }

    public String getFromUserId() {
        return this.fromUserId;
    }

    public String getGroup() {
        return this.group;
    }

    public Long getSequenceId() {
        return this.sequenceId;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeStringField("type", TYPE).writeStringField("from", FROM).writeStringField(FROM, this.group);
        if (this.dataType == WebPubSubDataFormat.TEXT) {
            jsonWriter.writeStringField("data", this.data.toString());
        } else if (this.dataType == WebPubSubDataFormat.BINARY || this.dataType == WebPubSubDataFormat.PROTOBUF) {
            jsonWriter.writeBinaryField("data", this.data.toBytes());
        } else {
            jsonWriter.writeRawField("data", this.data.toString());
        }
        return jsonWriter.writeStringField("dataType", this.dataType.toString()).writeStringField("fromUserId", this.fromUserId).writeNumberField("sequenceId", (Number)this.sequenceId).writeEndObject();
    }

    public static GroupDataMessage fromJson(JsonReader jsonReader) throws IOException {
        return (GroupDataMessage)jsonReader.readObject(reader -> {
            BinaryData data;
            String group = null;
            WebPubSubDataFormat dataType = null;
            String rawData = null;
            String fromUserId = null;
            Long sequenceId = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if (FROM.equals(fieldName)) {
                    group = reader.getString();
                    continue;
                }
                if ("dataType".equals(fieldName)) {
                    dataType = WebPubSubDataFormat.fromString(reader.getString());
                    continue;
                }
                if ("data".equals(fieldName)) {
                    if (reader.isStartArrayOrObject()) {
                        rawData = reader.readChildren();
                        continue;
                    }
                    if (reader.currentToken() == JsonToken.NULL) continue;
                    rawData = reader.getText();
                    continue;
                }
                if ("fromUserId".equals(fieldName)) {
                    fromUserId = reader.getString();
                    continue;
                }
                if ("sequenceId".equals(fieldName)) {
                    sequenceId = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            if (rawData == null) {
                data = null;
            } else if (dataType == WebPubSubDataFormat.TEXT) {
                data = BinaryData.fromString(rawData);
            } else if (dataType == WebPubSubDataFormat.BINARY || dataType == WebPubSubDataFormat.PROTOBUF) {
                data = BinaryData.fromBytes((byte[])Base64.getDecoder().decode(rawData));
            } else {
                try (JsonReader jsonReaderData = JsonProviders.createReader(rawData);){
                    data = BinaryData.fromObject((Object)jsonReaderData.readUntyped());
                }
            }
            return new GroupDataMessage(group, dataType, data, fromUserId, sequenceId);
        });
    }
}

