/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.client.implementation;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public final class SequenceAckId {
    private final AtomicLong sequenceId = new AtomicLong(0L);
    private final AtomicBoolean updated = new AtomicBoolean(false);

    public Long getUpdated() {
        if (this.updated.compareAndSet(true, false)) {
            return this.sequenceId.get();
        }
        return null;
    }

    public void setUpdated() {
        this.updated.set(true);
    }

    public boolean update(long id) {
        long previousId = this.sequenceId.getAndUpdate(existId -> Math.max(id, existId));
        this.updated.set(true);
        return id > previousId;
    }
}

