/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.client.implementation.websocket;

import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.webpubsub.client.implementation.models.WebPubSubMessage;
import com.azure.messaging.webpubsub.client.implementation.websocket.ClientEndpointConfiguration;
import com.azure.messaging.webpubsub.client.implementation.websocket.CloseReason;
import com.azure.messaging.webpubsub.client.implementation.websocket.WebSocketClient;
import com.azure.messaging.webpubsub.client.implementation.websocket.WebSocketSession;
import com.azure.messaging.webpubsub.client.implementation.websocket.WebSocketSessionNettyImpl;
import com.azure.messaging.webpubsub.client.models.ConnectFailedException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public final class WebSocketClientNettyImpl
implements WebSocketClient {
    @Override
    public WebSocketSession connectToServer(ClientEndpointConfiguration cec, String path, AtomicReference<ClientLogger> loggerReference, Consumer<WebPubSubMessage> messageHandler, Consumer<WebSocketSession> openHandler, Consumer<CloseReason> closeHandler) {
        try {
            WebSocketSessionNettyImpl session = new WebSocketSessionNettyImpl(cec, path, loggerReference, messageHandler, openHandler, closeHandler);
            session.connect();
            return session;
        }
        catch (Exception e) {
            throw loggerReference.get().logExceptionAsError((RuntimeException)((Object)new ConnectFailedException("Failed to connect", e)));
        }
    }
}

