/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.client.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.webpubsub.client.implementation.models.WebPubSubMessage;
import java.io.IOException;

public final class ConnectedMessage
extends WebPubSubMessage {
    private static final String TYPE = "system";
    private static final String EVENT = "connected";
    private final String connectionId;
    private String userId;
    private String reconnectionToken;

    public ConnectedMessage(String connectionId) {
        this.connectionId = connectionId;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getUserId() {
        return this.userId;
    }

    public ConnectedMessage setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String getReconnectionToken() {
        return this.reconnectionToken;
    }

    public ConnectedMessage setReconnectionToken(String reconnectionToken) {
        this.reconnectionToken = reconnectionToken;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("type", TYPE).writeStringField("event", EVENT).writeStringField("connectionId", this.connectionId).writeStringField("userId", this.userId).writeStringField("reconnectionToken", this.reconnectionToken).writeEndObject();
    }

    public static ConnectedMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectedMessage)jsonReader.readObject(reader -> {
            String connectionId = null;
            String userId = null;
            String reconnectionToken = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionId".equals(fieldName)) {
                    connectionId = reader.getString();
                    continue;
                }
                if ("userId".equals(fieldName)) {
                    userId = reader.getString();
                    continue;
                }
                if ("reconnectionToken".equals(fieldName)) {
                    reconnectionToken = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new ConnectedMessage(connectionId).setUserId(userId).setReconnectionToken(reconnectionToken);
        });
    }
}

