/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.client;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.http.policy.ExponentialBackoff;
import com.azure.core.http.policy.FixedDelay;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryStrategy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.UserAgentUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.webpubsub.client.WebPubSubAsyncClient;
import com.azure.messaging.webpubsub.client.WebPubSubClient;
import com.azure.messaging.webpubsub.client.implementation.websocket.WebSocketClient;
import com.azure.messaging.webpubsub.client.models.WebPubSubClientCredential;
import com.azure.messaging.webpubsub.client.models.WebPubSubProtocolType;
import java.util.Map;
import java.util.function.Supplier;

@ServiceClientBuilder(serviceClients={WebPubSubClient.class})
public final class WebPubSubClientBuilder
implements ConfigurationTrait<WebPubSubClientBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(WebPubSubClientBuilder.class);
    private static final String PROPERTIES = "azure-messaging-webpubsub-client.properties";
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private WebPubSubClientCredential credential;
    private String clientAccessUrl;
    private WebPubSubProtocolType webPubSubProtocol = WebPubSubProtocolType.JSON_RELIABLE_PROTOCOL;
    private ClientOptions clientOptions;
    private Configuration configuration;
    private final Map<String, String> properties = CoreUtils.getProperties((String)"azure-messaging-webpubsub-client.properties");
    private RetryOptions retryOptions = null;
    private boolean autoReconnect = true;
    private boolean autoRestoreGroup = true;
    WebSocketClient webSocketClient;

    public WebPubSubClientBuilder credential(WebPubSubClientCredential credential) {
        this.credential = credential;
        return this;
    }

    public WebPubSubClientBuilder clientAccessUrl(String clientAccessUrl) {
        this.clientAccessUrl = clientAccessUrl;
        return this;
    }

    public WebPubSubClientBuilder protocol(WebPubSubProtocolType webPubSubProtocol) {
        this.webPubSubProtocol = webPubSubProtocol;
        return this;
    }

    public WebPubSubClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public WebPubSubClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public WebPubSubClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public WebPubSubClientBuilder autoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
        return this;
    }

    public WebPubSubClientBuilder autoRestoreGroup(boolean autoRestoreGroup) {
        this.autoRestoreGroup = autoRestoreGroup;
        return this;
    }

    public WebPubSubClient buildClient() {
        return new WebPubSubClient(this.buildAsyncClient());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    WebPubSubAsyncClient buildAsyncClient() {
        Supplier<String> clientAccessUrlSuplier;
        ExponentialBackoff retryStrategy;
        if (this.retryOptions != null) {
            if (this.retryOptions.getExponentialBackoffOptions() != null) {
                retryStrategy = new ExponentialBackoff(this.retryOptions.getExponentialBackoffOptions());
            } else {
                if (this.retryOptions.getFixedDelayOptions() == null) throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'retryOptions' didn't define any retry strategy options"));
                retryStrategy = new FixedDelay(this.retryOptions.getFixedDelayOptions());
            }
        } else {
            retryStrategy = new ExponentialBackoff();
        }
        if (this.credential != null && this.clientAccessUrl != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Both credential and clientAccessUrl have been set. Set null to one of them to clear that option."));
        }
        if (this.credential != null) {
            clientAccessUrlSuplier = this.credential.getClientAccessUrlSupplier();
        } else {
            if (this.clientAccessUrl == null) throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Credentials have not been set. They can be set using: clientAccessUrl(String), credential(WebPubSubClientCredential)"));
            clientAccessUrlSuplier = () -> this.clientAccessUrl;
        }
        String clientName = this.properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = this.properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        String applicationId = CoreUtils.getApplicationId((ClientOptions)this.clientOptions, null);
        String userAgent = UserAgentUtil.toUserAgentString((String)applicationId, (String)clientName, (String)clientVersion, (Configuration)(this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration));
        return new WebPubSubAsyncClient(this.webSocketClient, clientAccessUrlSuplier, this.webPubSubProtocol, applicationId, userAgent, (RetryStrategy)retryStrategy, this.autoReconnect, this.autoRestoreGroup);
    }
}

