/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.client.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.webpubsub.client.implementation.models.AckMessage;
import com.azure.messaging.webpubsub.client.implementation.models.ConnectedMessage;
import com.azure.messaging.webpubsub.client.implementation.models.DisconnectedMessage;
import com.azure.messaging.webpubsub.client.implementation.models.GroupDataMessage;
import com.azure.messaging.webpubsub.client.implementation.models.JoinGroupMessage;
import com.azure.messaging.webpubsub.client.implementation.models.LeaveGroupMessage;
import com.azure.messaging.webpubsub.client.implementation.models.SendEventMessage;
import com.azure.messaging.webpubsub.client.implementation.models.SendToGroupMessage;
import com.azure.messaging.webpubsub.client.implementation.models.SequenceAckMessage;
import com.azure.messaging.webpubsub.client.implementation.models.ServerDataMessage;
import java.io.IOException;

public class WebPubSubMessage
implements JsonSerializable<WebPubSubMessage> {
    protected WebPubSubMessage() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeEndObject();
    }

    public static WebPubSubMessage fromJson(JsonReader jsonReader) throws IOException {
        return (WebPubSubMessage)jsonReader.readObject(reader -> {
            String typeToUse = null;
            String eventToUse = null;
            String fromToUse = null;
            JsonReader readerToUse = reader.bufferObject();
            readerToUse.nextToken();
            while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = readerToUse.getFieldName();
                readerToUse.nextToken();
                if ("type".equals(fieldName)) {
                    typeToUse = readerToUse.getString();
                    continue;
                }
                if ("event".equals(fieldName)) {
                    eventToUse = readerToUse.getString();
                    continue;
                }
                if ("from".equals(fieldName)) {
                    fromToUse = readerToUse.getString();
                    continue;
                }
                readerToUse.skipChildren();
            }
            if ("ack".equals(typeToUse)) {
                return AckMessage.fromJson(readerToUse.reset());
            }
            if ("system".equals(typeToUse)) {
                if ("connected".equals(eventToUse)) {
                    return ConnectedMessage.fromJson(readerToUse.reset());
                }
                if ("disconnected".equals(eventToUse)) {
                    return DisconnectedMessage.fromJson(readerToUse.reset());
                }
            } else if ("message".equals(typeToUse)) {
                if ("group".equals(fromToUse)) {
                    return GroupDataMessage.fromJson(readerToUse.reset());
                }
                if ("server".equals(fromToUse)) {
                    return ServerDataMessage.fromJson(readerToUse.reset());
                }
            } else {
                if ("joinGroup".equals(typeToUse)) {
                    return JoinGroupMessage.fromJson(readerToUse.reset());
                }
                if ("leaveGroup".equals(typeToUse)) {
                    return LeaveGroupMessage.fromJson(readerToUse.reset());
                }
                if ("event".equals(typeToUse)) {
                    return SendEventMessage.fromJson(readerToUse.reset());
                }
                if ("sendToGroup".equals(typeToUse)) {
                    return SendToGroupMessage.fromJson(readerToUse.reset());
                }
                if ("sequenceAck".equals(typeToUse)) {
                    return SequenceAckMessage.fromJson(readerToUse.reset());
                }
            }
            return null;
        });
    }
}

