/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.client.implementation.models;

import com.azure.core.util.BinaryData;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.webpubsub.client.implementation.models.WebPubSubMessage;
import com.azure.messaging.webpubsub.client.models.WebPubSubDataFormat;
import java.io.IOException;
import java.util.Base64;

public final class ServerDataMessage
extends WebPubSubMessage {
    private static final String TYPE = "message";
    private static final String FROM = "server";
    private final WebPubSubDataFormat dataType;
    private final BinaryData data;
    private final Long sequenceId;

    public ServerDataMessage(WebPubSubDataFormat dataType, BinaryData data, Long sequenceId) {
        this.data = data;
        this.dataType = dataType;
        this.sequenceId = sequenceId;
    }

    public BinaryData getData() {
        return this.data;
    }

    public WebPubSubDataFormat getDataType() {
        return this.dataType;
    }

    public Long getSequenceId() {
        return this.sequenceId;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeStringField("type", TYPE).writeStringField("from", FROM).writeStringField("dataType", this.dataType.toString());
        if (this.dataType == WebPubSubDataFormat.TEXT) {
            jsonWriter.writeStringField("data", this.data.toString());
        } else if (this.dataType == WebPubSubDataFormat.BINARY || this.dataType == WebPubSubDataFormat.PROTOBUF) {
            jsonWriter.writeBinaryField("data", this.data.toBytes());
        } else {
            jsonWriter.writeRawField("data", this.data.toString());
        }
        return jsonWriter.writeNumberField("sequenceId", (Number)this.sequenceId).writeEndObject();
    }

    public static ServerDataMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ServerDataMessage)jsonReader.readObject(reader -> {
            BinaryData data;
            WebPubSubDataFormat dataType = null;
            String rawData = null;
            Long sequenceId = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataType".equals(fieldName)) {
                    dataType = WebPubSubDataFormat.fromString(reader.getString());
                    continue;
                }
                if ("data".equals(fieldName)) {
                    if (reader.isStartArrayOrObject()) {
                        rawData = reader.readChildren();
                        continue;
                    }
                    if (reader.currentToken() == JsonToken.NULL) continue;
                    rawData = reader.getText();
                    continue;
                }
                if ("sequenceId".equals(fieldName)) {
                    sequenceId = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            if (rawData == null) {
                data = null;
            } else if (dataType == WebPubSubDataFormat.TEXT) {
                data = BinaryData.fromString(rawData);
            } else if (dataType == WebPubSubDataFormat.BINARY || dataType == WebPubSubDataFormat.PROTOBUF) {
                data = BinaryData.fromBytes((byte[])Base64.getDecoder().decode(rawData));
            } else {
                try (JsonReader jsonReaderData = JsonProviders.createReader(rawData);){
                    data = BinaryData.fromObject((Object)jsonReaderData.readUntyped());
                }
            }
            return new ServerDataMessage(dataType, data, sequenceId);
        });
    }
}

