/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.client.implementation.websocket;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.webpubsub.client.implementation.MessageDecoder;
import com.azure.messaging.webpubsub.client.implementation.MessageEncoder;
import com.azure.messaging.webpubsub.client.implementation.models.WebPubSubMessage;
import com.azure.messaging.webpubsub.client.implementation.websocket.ClientEndpointConfiguration;
import com.azure.messaging.webpubsub.client.implementation.websocket.CloseReason;
import com.azure.messaging.webpubsub.client.implementation.websocket.SendResult;
import com.azure.messaging.webpubsub.client.implementation.websocket.WebSocketClientHandler;
import com.azure.messaging.webpubsub.client.implementation.websocket.WebSocketSession;
import com.azure.messaging.webpubsub.client.models.ConnectFailedException;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;

final class WebSocketSessionNettyImpl
implements WebSocketSession {
    private final AtomicReference<ClientLogger> loggerReference;
    private final MessageEncoder messageEncoder;
    private final MessageDecoder messageDecoder;
    private final String path;
    private final String protocol;
    private final String userAgent;
    private final Consumer<WebPubSubMessage> messageHandler;
    private final Consumer<WebSocketSession> openHandler;
    private final Consumer<CloseReason> closeHandler;
    private EventLoopGroup group;
    private WebSocketClientHandshaker handshaker;
    private WebSocketClientHandler clientHandler;
    private Channel ch;

    WebSocketSessionNettyImpl(ClientEndpointConfiguration cec, String path, AtomicReference<ClientLogger> loggerReference, Consumer<WebPubSubMessage> messageHandler, Consumer<WebSocketSession> openHandler, Consumer<CloseReason> closeHandler) {
        this.path = path;
        this.loggerReference = loggerReference;
        this.messageEncoder = cec.getMessageEncoder();
        this.messageDecoder = cec.getMessageDecoder();
        this.protocol = cec.getProtocol();
        this.userAgent = cec.getUserAgent();
        this.messageHandler = messageHandler;
        this.openHandler = openHandler;
        this.closeHandler = closeHandler;
    }

    void connect() throws URISyntaxException, SSLException, InterruptedException, ExecutionException {
        String host;
        URI uri = new URI(this.path);
        String scheme = uri.getScheme() == null ? "ws" : uri.getScheme();
        String string = host = uri.getHost() == null ? "127.0.0.1" : uri.getHost();
        int port = uri.getPort() == -1 ? ("ws".equalsIgnoreCase(scheme) ? 80 : ("wss".equalsIgnoreCase(scheme) ? 443 : -1)) : uri.getPort();
        if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException("Only WS(S) is supported.");
        }
        boolean ssl = "wss".equalsIgnoreCase(scheme);
        SslContext sslCtx = ssl ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : null;
        this.group = new NioEventLoopGroup();
        this.handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, (String)this.protocol, (boolean)true, (HttpHeaders)new DefaultHttpHeaders().add(HttpHeaderName.USER_AGENT.getCaseInsensitiveName(), (Object)this.userAgent));
        this.clientHandler = new WebSocketClientHandler(this.handshaker, this.loggerReference, this.messageDecoder, this.messageHandler);
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new WebSocketChannelHandler(host, port, sslCtx, this.clientHandler));
        CompletableFuture handshakeCallbackFuture = new CompletableFuture();
        this.ch = b.connect(uri.getHost(), port).sync().channel();
        this.clientHandler.handshakeFuture().addListener(future -> {
            if (future.isSuccess()) {
                this.openHandler.accept(this);
            }
            handshakeCallbackFuture.complete(null);
        }).sync();
        this.ch.closeFuture().addListener(future -> {
            if (this.clientHandler != null) {
                CompletableFuture<Void> closeCallbackFuture;
                if (future.isSuccess()) {
                    CloseWebSocketFrame closeFrame = this.clientHandler.getServerCloseWebSocketFrame();
                    if (closeFrame == null) {
                        closeFrame = new CloseWebSocketFrame(WebSocketCloseStatus.NORMAL_CLOSURE);
                    }
                    this.closeHandler.accept(new CloseReason(closeFrame.statusCode(), closeFrame.reasonText()));
                    closeFrame.release();
                }
                if ((closeCallbackFuture = this.clientHandler.getClientCloseCallbackFuture()) != null) {
                    closeCallbackFuture.complete(null);
                }
            }
        });
        handshakeCallbackFuture.get();
    }

    @Override
    public boolean isOpen() {
        return this.ch != null && this.ch.isOpen() && this.handshaker != null && this.handshaker.isHandshakeComplete();
    }

    @Override
    public void sendObjectAsync(Object data, Consumer<SendResult> handler) {
        if (this.ch != null && this.ch.isOpen()) {
            String msg = this.messageEncoder.encode((WebPubSubMessage)data);
            this.sendTextAsync(msg, handler);
        } else {
            handler.accept(new SendResult(new IllegalStateException("Channel is closed")));
        }
    }

    @Override
    public void sendTextAsync(String text, Consumer<SendResult> handler) {
        if (this.ch != null && this.ch.isOpen()) {
            TextWebSocketFrame frame = new TextWebSocketFrame(text);
            this.loggerReference.get().atVerbose().addKeyValue("text", frame.text()).log("Send TextWebSocketFrame");
            this.ch.writeAndFlush((Object)frame).addListener(future -> {
                if (future.isSuccess()) {
                    handler.accept(new SendResult());
                } else {
                    handler.accept(new SendResult(future.cause()));
                }
            });
        } else {
            handler.accept(new SendResult(new IllegalStateException("Channel is closed")));
        }
    }

    @Override
    public void closeSocket() {
        if (this.group != null) {
            try {
                if (this.ch != null && this.ch.isOpen() && this.clientHandler != null) {
                    this.ch.close();
                    this.ch.closeFuture().sync();
                }
                this.group.shutdownGracefully();
            }
            catch (InterruptedException e) {
                throw this.loggerReference.get().logExceptionAsError((RuntimeException)((Object)new ConnectFailedException("Failed to disconnect", e)));
            }
        }
    }

    @Override
    public void close() {
        if (this.group != null) {
            try {
                CompletableFuture<Void> closeCallbackFuture = null;
                if (this.ch != null && this.ch.isOpen() && this.clientHandler != null) {
                    closeCallbackFuture = new CompletableFuture<Void>();
                    this.clientHandler.setClientCloseCallbackFuture(closeCallbackFuture);
                    CloseWebSocketFrame closeFrame = new CloseWebSocketFrame(WebSocketCloseStatus.NORMAL_CLOSURE);
                    this.loggerReference.get().atVerbose().addKeyValue("statusCode", (long)closeFrame.statusCode()).addKeyValue("reasonText", closeFrame.reasonText()).log("Send CloseWebSocketFrame");
                    this.ch.writeAndFlush((Object)closeFrame);
                    this.ch.closeFuture().sync();
                }
                this.group.shutdownGracefully();
                if (closeCallbackFuture != null) {
                    closeCallbackFuture.get();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw this.loggerReference.get().logExceptionAsError((RuntimeException)((Object)new ConnectFailedException("Failed to disconnect", e)));
            }
        }
    }

    private static final class WebSocketChannelHandler
    extends ChannelInitializer<SocketChannel> {
        private final String host;
        private final int port;
        private final SslContext sslCtx;
        private final WebSocketClientHandler handler;

        private WebSocketChannelHandler(String host, int port, SslContext sslCtx, WebSocketClientHandler handler) {
            this.host = host;
            this.port = port;
            this.sslCtx = sslCtx;
            this.handler = handler;
        }

        protected void initChannel(SocketChannel ch) {
            ChannelPipeline p = ch.pipeline();
            if (this.sslCtx != null) {
                p.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc(), this.host, this.port)});
            }
            p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), WebSocketClientCompressionHandler.INSTANCE, this.handler});
        }
    }
}

