/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.client.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.webpubsub.client.implementation.models.WebPubSubMessageAck;
import java.io.IOException;

public final class JoinGroupMessage
extends WebPubSubMessageAck {
    private static final String TYPE = "joinGroup";
    private String group;

    public String getType() {
        return TYPE;
    }

    public String getGroup() {
        return this.group;
    }

    public JoinGroupMessage setGroup(String group) {
        this.group = group;
        return this;
    }

    @Override
    public JoinGroupMessage setAckId(Long ackId) {
        super.setAckId(ackId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("type", TYPE).writeNumberField("ackId", (Number)this.getAckId()).writeStringField("group", this.group).writeEndObject();
    }

    public static JoinGroupMessage fromJson(JsonReader jsonReader) throws IOException {
        return (JoinGroupMessage)jsonReader.readObject(reader -> {
            JoinGroupMessage joinGroupMessage = new JoinGroupMessage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ackId".equals(fieldName)) {
                    joinGroupMessage.setAckId((Long)reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("group".equals(fieldName)) {
                    joinGroupMessage.group = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return joinGroupMessage;
        });
    }
}

