/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.client.implementation.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.webpubsub.client.implementation.models.WebPubSubMessage;
import com.azure.messaging.webpubsub.client.models.AckResponseError;
import java.io.IOException;

public final class AckMessage
extends WebPubSubMessage {
    private static final String TYPE = "ack";
    private long ackId;
    private boolean success;
    private AckResponseError error;

    public long getAckId() {
        return this.ackId;
    }

    public AckMessage setAckId(long ackId) {
        this.ackId = ackId;
        return this;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public AckMessage setSuccess(boolean success) {
        this.success = success;
        return this;
    }

    public AckResponseError getError() {
        return this.error;
    }

    public AckMessage setError(AckResponseError error) {
        this.error = error;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeStartObject().writeStringField("type", TYPE).writeNumberField("ackId", (Number)this.ackId).writeBooleanField("success", this.success).writeJsonField("error", (JsonSerializable)this.error).writeEndObject();
    }

    public static AckMessage fromJson(JsonReader jsonReader) throws IOException {
        return (AckMessage)jsonReader.readObject(reader -> {
            AckMessage ackMessage = new AckMessage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ackId".equals(fieldName)) {
                    ackMessage.ackId = reader.getLong();
                    continue;
                }
                if ("success".equals(fieldName)) {
                    ackMessage.success = reader.getBoolean();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    ackMessage.error = AckResponseError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return ackMessage;
        });
    }
}

