/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.client.implementation;

import com.azure.messaging.webpubsub.client.implementation.SequenceAckId;
import java.util.concurrent.atomic.AtomicBoolean;

public class WebPubSubConnection {
    private String connectionId;
    private String reconnectionToken;
    private final SequenceAckId sequenceAckId = new SequenceAckId();
    private final AtomicBoolean disconnected = new AtomicBoolean(false);

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getReconnectionToken() {
        return this.reconnectionToken;
    }

    public SequenceAckId getSequenceAckId() {
        return this.sequenceAckId;
    }

    public void updateForConnected(String connectionId, String reconnectionToken, Runnable action) {
        boolean newConnectionId = this.connectionId == null;
        this.connectionId = connectionId;
        this.reconnectionToken = reconnectionToken;
        if (newConnectionId) {
            action.run();
        }
    }

    public void updateForDisconnected(Runnable action) {
        if (!this.disconnected.getAndSet(true)) {
            action.run();
        }
    }
}

