/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.client.implementation;

import com.azure.core.util.BinaryData;
import com.azure.json.JsonProviders;
import com.azure.json.JsonWriter;
import com.azure.messaging.webpubsub.client.implementation.models.SendEventMessage;
import com.azure.messaging.webpubsub.client.implementation.models.SendToGroupMessage;
import com.azure.messaging.webpubsub.client.implementation.models.WebPubSubMessage;
import com.azure.messaging.webpubsub.client.models.WebPubSubDataFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Base64;
import java.util.function.Consumer;

public final class MessageEncoder {
    /*
     * Enabled aggressive exception aggregation
     */
    public String encode(WebPubSubMessage object) {
        if (object instanceof SendToGroupMessage) {
            MessageEncoder.updateDataForType((SendToGroupMessage)object);
        } else if (object instanceof SendEventMessage) {
            MessageEncoder.updateDataForType((SendEventMessage)object);
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            String string;
            block16: {
                JsonWriter writer = JsonProviders.createWriter((OutputStream)outputStream);
                try {
                    object.toJson(writer).flush();
                    string = outputStream.toString();
                    if (writer == null) break block16;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                writer.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static void updateDataForType(SendToGroupMessage message) {
        MessageEncoder.updateDataForType(message.getDataType(), message.getData(), message::setData);
    }

    private static void updateDataForType(SendEventMessage message) {
        MessageEncoder.updateDataForType(message.getDataType(), message.getData(), message::setData);
    }

    private static void updateDataForType(String dataType, Object data, Consumer<Object> dataUpdater) {
        if (WebPubSubDataFormat.BINARY.toString().equals(dataType) || WebPubSubDataFormat.PROTOBUF.toString().equals(dataType)) {
            if (data instanceof BinaryData) {
                BinaryData content = (BinaryData)data;
                data = Base64.getEncoder().encodeToString(content.toBytes());
                dataUpdater.accept(data);
            }
        } else if (WebPubSubDataFormat.TEXT.toString().equals(dataType) && data instanceof BinaryData) {
            BinaryData content = (BinaryData)data;
            data = content.toString();
            dataUpdater.accept(data);
        }
    }
}

