/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.util.logging.ClientLogger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

class PartitionResolver {
    private static final ClientLogger LOGGER = new ClientLogger(PartitionResolver.class);
    private static final int STARTING_INDEX = -1;
    private final AtomicInteger partitionAssignmentIndex = new AtomicInteger(-1);

    PartitionResolver() {
    }

    String assignRoundRobin(String[] partitions) {
        Objects.requireNonNull(partitions, "'partitions' cannot be null.");
        if (partitions.length == 0) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'partitions' cannot be empty."));
        }
        int currentIndex = this.partitionAssignmentIndex.accumulateAndGet(1, (current, added) -> {
            try {
                return Math.addExact(current, added);
            }
            catch (ArithmeticException e) {
                LOGGER.info("Overflowed incrementing index. Rolling over.", new Object[]{e});
                return -1 + added;
            }
        });
        return partitions[currentIndex % partitions.length];
    }

    String assignForPartitionKey(String partitionKey, String[] partitions) {
        short hashValue = PartitionResolver.generateHashCode(partitionKey);
        int index = Math.abs(hashValue % partitions.length);
        return partitions[index];
    }

    static short generateHashCode(String partitionKey) {
        if (partitionKey == null) {
            return 0;
        }
        byte[] bytes = partitionKey.getBytes(StandardCharsets.UTF_8);
        Hashed hashed = PartitionResolver.computeHash(bytes, 0, 0);
        int i = hashed.getHash1() ^ hashed.getHash2();
        return Integer.valueOf(i).shortValue();
    }

    private static Hashed computeHash(byte[] data, int seed1, int seed2) {
        int size;
        int a;
        int b = a = -559038737 + data.length + seed1;
        int c = a + seed2;
        ByteBuffer buffer = ByteBuffer.allocate(data.length).put(data);
        buffer.flip();
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int index = 0;
        for (size = data.length; size > 12; size -= 12) {
            a += buffer.getInt(index);
            a -= (c += buffer.getInt(index + 8));
            a ^= c << 4 | c >>> 28;
            b -= a;
            b ^= a << 6 | a >>> 26;
            a += (c += (b += buffer.getInt(index + 4)));
            c -= b;
            c ^= b << 8 | b >>> 24;
            b += a;
            a -= c;
            a ^= c << 16 | c >>> 16;
            c += b;
            b -= a;
            b ^= a << 19 | a >>> 13;
            a += c;
            c -= b;
            c ^= b << 4 | b >>> 28;
            b += a;
            index += 12;
        }
        switch (size) {
            case 12: {
                a += buffer.getInt(index);
                b += buffer.getInt(index + 4);
                c += buffer.getInt(index + 8);
                break;
            }
            case 11: {
                c += data[index + 10] << 16;
            }
            case 10: {
                c += data[index + 9] << 8;
            }
            case 9: {
                c += data[index + 8];
            }
            case 8: {
                b += buffer.getInt(index + 4);
                a += buffer.getInt(index);
                break;
            }
            case 7: {
                b += data[index + 6] << 16;
            }
            case 6: {
                b += data[index + 5] << 8;
            }
            case 5: {
                b += data[index + 4];
            }
            case 4: {
                a += buffer.getInt(index);
                break;
            }
            case 3: {
                a += data[index + 2] << 16;
            }
            case 2: {
                a += data[index + 1] << 8;
            }
            case 1: {
                a += data[index];
                break;
            }
            case 0: {
                return new Hashed(c, b);
            }
        }
        c ^= b;
        a ^= (c -= b << 14 | b >>> 18);
        b ^= (a -= c << 11 | c >>> 21);
        c ^= (b -= a << 25 | a >>> 7);
        a ^= (c -= b << 16 | b >>> 16);
        b ^= (a -= c << 4 | c >>> 28);
        c ^= (b -= a << 14 | a >>> 18);
        return new Hashed(c -= b << 24 | b >>> 8, b);
    }

    private static class Hashed {
        private final int hash1;
        private final int hash2;

        Hashed(int hash1, int hash2) {
            this.hash1 = hash1;
            this.hash2 = hash2;
        }

        public int getHash1() {
            return this.hash1;
        }

        public int getHash2() {
            return this.hash2;
        }
    }
}

