/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.AmqpMessageConstant;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.models.AmqpAnnotatedMessage;
import com.azure.core.exception.AzureException;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.EventHubProperties;
import com.azure.messaging.eventhubs.Messages;
import com.azure.messaging.eventhubs.PartitionProperties;
import com.azure.messaging.eventhubs.SystemProperties;
import com.azure.messaging.eventhubs.implementation.MessageUtils;
import com.azure.messaging.eventhubs.models.LastEnqueuedEventProperties;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.codec.AMQPType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.Encoder;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.TypeEncoding;
import org.apache.qpid.proton.message.Message;

class EventHubMessageSerializer
implements MessageSerializer {
    private static final Encoder ENCODER = new EncoderImpl(new DecoderImpl());
    private static final ClientLogger LOGGER = new ClientLogger(EventHubMessageSerializer.class);
    private static final Symbol LAST_ENQUEUED_SEQUENCE_NUMBER = Symbol.getSymbol((String)"last_enqueued_sequence_number");
    private static final Symbol LAST_ENQUEUED_OFFSET = Symbol.getSymbol((String)"last_enqueued_offset");
    private static final Symbol LAST_ENQUEUED_TIME_UTC = Symbol.getSymbol((String)"last_enqueued_time_utc");
    private static final Symbol RETRIEVAL_TIME_UTC = Symbol.getSymbol((String)"runtime_info_retrieval_time_utc");

    EventHubMessageSerializer() {
    }

    public int getSize(Message amqpMessage) {
        int size;
        Map map;
        if (amqpMessage == null) {
            return 0;
        }
        int payloadSize = EventHubMessageSerializer.getPayloadSize(amqpMessage);
        MessageAnnotations messageAnnotations = amqpMessage.getMessageAnnotations();
        DeliveryAnnotations deliveryAnnotations = amqpMessage.getDeliveryAnnotations();
        ApplicationProperties applicationProperties = amqpMessage.getApplicationProperties();
        int annotationsSize = 0;
        int deliveryAnnotationsSize = 0;
        int applicationPropertiesSize = 0;
        if (messageAnnotations != null) {
            map = messageAnnotations.getValue();
            for (Map.Entry entry : map.entrySet()) {
                size = EventHubMessageSerializer.sizeof(entry.getKey()) + EventHubMessageSerializer.sizeof(entry.getValue());
                annotationsSize += size;
            }
        }
        if (deliveryAnnotations != null) {
            map = deliveryAnnotations.getValue();
            for (Map.Entry entry : map.entrySet()) {
                size = EventHubMessageSerializer.sizeof(entry.getKey()) + EventHubMessageSerializer.sizeof(entry.getValue());
                deliveryAnnotationsSize += size;
            }
        }
        if (applicationProperties != null) {
            map = applicationProperties.getValue();
            for (Map.Entry entry : map.entrySet()) {
                size = EventHubMessageSerializer.sizeof(entry.getKey()) + EventHubMessageSerializer.sizeof(entry.getValue());
                applicationPropertiesSize += size;
            }
        }
        return annotationsSize + deliveryAnnotationsSize + applicationPropertiesSize + payloadSize;
    }

    public <T> Message serialize(T object) {
        Objects.requireNonNull(object, "'object' to serialize cannot be null.");
        if (!(object instanceof EventData)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Cannot serialize object that is not EventData. Class: " + object.getClass()));
        }
        EventData eventData = (EventData)((Object)object);
        return MessageUtils.toProtonJMessage(eventData.getRawAmqpMessage());
    }

    public <T> T deserialize(Message message, Class<T> clazz) {
        Objects.requireNonNull(message, "'message' cannot be null.");
        Objects.requireNonNull(clazz, "'clazz' cannot be null.");
        if (clazz == PartitionProperties.class || clazz == EventHubProperties.class) {
            return this.deserializeManagementResponse(message, clazz);
        }
        if (clazz == EventData.class) {
            return (T)((Object)this.deserializeEventData(message));
        }
        if (clazz == LastEnqueuedEventProperties.class) {
            return (T)this.deserializeEnqueuedEventProperties(message);
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Deserialization only supports EventData, PartitionProperties, or EventHubProperties."));
    }

    public <T> List<T> deserializeList(Message message, Class<T> clazz) {
        return Collections.singletonList(this.deserialize(message, clazz));
    }

    private <T> T deserializeManagementResponse(Message message, Class<T> deserializedType) {
        if (!(message.getBody() instanceof AmqpValue)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Expected message.getBody() to be AmqpValue, but is: " + message.getBody()));
        }
        AmqpValue body = (AmqpValue)message.getBody();
        if (!(body.getValue() instanceof Map)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Expected message.getBody().getValue() to be of type Map"));
        }
        Map amqpBody = (Map)body.getValue();
        if (deserializedType == PartitionProperties.class) {
            return (T)this.toPartitionProperties(amqpBody);
        }
        if (deserializedType == EventHubProperties.class) {
            return (T)this.toEventHubProperties(amqpBody);
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format(Messages.CLASS_NOT_A_SUPPORTED_TYPE, deserializedType)));
    }

    private LastEnqueuedEventProperties deserializeEnqueuedEventProperties(Message message) {
        DeliveryAnnotations annotations = message.getDeliveryAnnotations();
        if (annotations == null || annotations.getValue() == null) {
            return null;
        }
        Map deliveryAnnotations = annotations.getValue();
        Long lastSequenceNumber = this.getValue(deliveryAnnotations, LAST_ENQUEUED_SEQUENCE_NUMBER, Long.class);
        String lastEnqueuedOffset = this.getValue(deliveryAnnotations, LAST_ENQUEUED_OFFSET, String.class);
        Instant lastEnqueuedTime = this.getValue(deliveryAnnotations, LAST_ENQUEUED_TIME_UTC, Date.class).toInstant();
        Instant retrievalTime = this.getValue(deliveryAnnotations, RETRIEVAL_TIME_UTC, Date.class).toInstant();
        return new LastEnqueuedEventProperties(lastSequenceNumber, Long.valueOf(lastEnqueuedOffset), lastEnqueuedTime, retrievalTime);
    }

    private EventData deserializeEventData(Message message) {
        AmqpAnnotatedMessage amqpAnnotatedMessage = MessageUtils.toAmqpAnnotatedMessage(message);
        Map messageAnnotations = amqpAnnotatedMessage.getMessageAnnotations();
        if (!messageAnnotations.containsKey(AmqpMessageConstant.OFFSET_ANNOTATION_NAME.getValue())) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format(Locale.US, "offset: %s should always be in map.", AmqpMessageConstant.OFFSET_ANNOTATION_NAME.getValue())));
        }
        if (!messageAnnotations.containsKey(AmqpMessageConstant.ENQUEUED_TIME_UTC_ANNOTATION_NAME.getValue())) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format(Locale.US, "enqueuedTime: %s should always be in map.", AmqpMessageConstant.ENQUEUED_TIME_UTC_ANNOTATION_NAME.getValue())));
        }
        if (!messageAnnotations.containsKey(AmqpMessageConstant.SEQUENCE_NUMBER_ANNOTATION_NAME.getValue())) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format(Locale.US, "enqueuedTime: %s should always be in map.", AmqpMessageConstant.SEQUENCE_NUMBER_ANNOTATION_NAME.getValue())));
        }
        Instant enqueuedTime = MessageUtils.getEnqueuedTime(messageAnnotations, AmqpMessageConstant.ENQUEUED_TIME_UTC_ANNOTATION_NAME.getValue());
        String partitionKey = (String)messageAnnotations.get(AmqpMessageConstant.PARTITION_KEY_ANNOTATION_NAME.getValue());
        long offset = this.getAsLong(messageAnnotations, AmqpMessageConstant.OFFSET_ANNOTATION_NAME.getValue());
        long sequenceNumber = this.getAsLong(messageAnnotations, AmqpMessageConstant.SEQUENCE_NUMBER_ANNOTATION_NAME.getValue());
        messageAnnotations.put(AmqpMessageConstant.OFFSET_ANNOTATION_NAME.getValue(), offset);
        messageAnnotations.put(AmqpMessageConstant.ENQUEUED_TIME_UTC_ANNOTATION_NAME.getValue(), enqueuedTime);
        messageAnnotations.put(AmqpMessageConstant.SEQUENCE_NUMBER_ANNOTATION_NAME.getValue(), sequenceNumber);
        SystemProperties systemProperties = new SystemProperties(amqpAnnotatedMessage, offset, enqueuedTime, sequenceNumber, partitionKey);
        EventData eventData = new EventData(amqpAnnotatedMessage, systemProperties, Context.NONE);
        message.clear();
        return eventData;
    }

    private EventHubProperties toEventHubProperties(Map<?, ?> amqpBody) {
        return new EventHubProperties(this.getValue(amqpBody, "name", String.class), this.getDate(amqpBody, "created_at"), this.getValue(amqpBody, "partition_ids", String[].class));
    }

    private PartitionProperties toPartitionProperties(Map<?, ?> amqpBody) {
        return new PartitionProperties(this.getValue(amqpBody, "name", String.class), this.getValue(amqpBody, "partition", String.class), this.getValue(amqpBody, "begin_sequence_number", Long.class), this.getValue(amqpBody, "last_enqueued_sequence_number", Long.class), this.getValue(amqpBody, "last_enqueued_offset", String.class), this.getDate(amqpBody, "last_enqueued_time_utc"), this.getValue(amqpBody, "is_partition_empty", Boolean.class));
    }

    private long getAsLong(Map<String, Object> amqpBody, String key) {
        long value;
        Object object = amqpBody.get(key);
        if (object instanceof String) {
            try {
                value = Long.parseLong((String)object);
            }
            catch (NumberFormatException e) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("'" + key + "' could not be parsed into a Long. Value: " + object, e));
            }
        } else if (object instanceof Long) {
            value = (Long)object;
        } else {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(new IllegalStateException(String.format(Locale.US, "'" + key + "' value is not a known type. Value: %s. Type: %s", object, object.getClass()))));
        }
        return value;
    }

    private <T> T getValue(Map<?, ?> amqpBody, String key, Class<T> clazz) {
        if (!amqpBody.containsKey(key)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new AzureException(String.format("AMQP body did not contain expected field '%s'.", key)));
        }
        return this.getValue(amqpBody.get(key), (Object)key, clazz);
    }

    private <T> T getValue(Map<Symbol, Object> amqpBody, Symbol key, Class<T> clazz) {
        if (!amqpBody.containsKey(key)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new AzureException(String.format("AMQP body did not contain expected field '%s'.", key)));
        }
        return this.getValue(amqpBody.get(key), (Object)key, clazz);
    }

    private <T> T getValue(Object value, Object key, Class<T> clazz) {
        if (value == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new AzureException(String.format("AMQP body did not contain a value for key '%s'.", key)));
        }
        if (value.getClass() != clazz) {
            throw LOGGER.logExceptionAsError((RuntimeException)new AzureException(String.format("AMQP body did not contain correct value for key '%s'. Expected class: '%s'. Actual: '%s'", key, clazz, value.getClass())));
        }
        return (T)value;
    }

    private Instant getDate(Map<?, ?> amqpBody, String key) {
        Date value = this.getValue(amqpBody, key, Date.class);
        return value.toInstant();
    }

    private static int getPayloadSize(Message msg) {
        if (msg == null || msg.getBody() == null) {
            return 0;
        }
        if (msg.getBody() instanceof Data) {
            Data payloadSection = (Data)msg.getBody();
            if (payloadSection == null) {
                return 0;
            }
            Binary payloadBytes = payloadSection.getValue();
            if (payloadBytes == null) {
                return 0;
            }
            return payloadBytes.getLength();
        }
        if (msg.getBody() instanceof AmqpValue) {
            AmqpValue amqpValue = (AmqpValue)msg.getBody();
            if (amqpValue == null) {
                return 0;
            }
            return amqpValue.getValue().toString().length() * 2;
        }
        return 0;
    }

    private static int sizeof(Object obj) {
        if (obj == null) {
            return 0;
        }
        AMQPType amqpType = ENCODER.getType(obj);
        if (amqpType == null) {
            throw new IllegalArgumentException(String.format(Messages.ENCODING_TYPE_NOT_SUPPORTED, obj.getClass()));
        }
        TypeEncoding encoding = amqpType.getEncoding(obj);
        if (encoding == null) {
            throw new IllegalArgumentException(String.format(Messages.ENCODING_TYPE_NOT_SUPPORTED_ENCODER, obj.getClass()));
        }
        return encoding.getValueSize(obj);
    }
}

