/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.StorageTaskCompletedStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

@Deprecated
public final class StorageTaskCompletedEventData
implements JsonSerializable<StorageTaskCompletedEventData> {
    private StorageTaskCompletedStatus status;
    private OffsetDateTime completedDateTime;
    private String taskExecutionId;
    private String taskName;
    private String summaryReportBlobUrl;

    public StorageTaskCompletedStatus getStatus() {
        return this.status;
    }

    public StorageTaskCompletedEventData setStatus(StorageTaskCompletedStatus status) {
        this.status = status;
        return this;
    }

    public OffsetDateTime getCompletedDateTime() {
        return this.completedDateTime;
    }

    public StorageTaskCompletedEventData setCompletedDateTime(OffsetDateTime completedDateTime) {
        this.completedDateTime = completedDateTime;
        return this;
    }

    public String getTaskExecutionId() {
        return this.taskExecutionId;
    }

    public StorageTaskCompletedEventData setTaskExecutionId(String taskExecutionId) {
        this.taskExecutionId = taskExecutionId;
        return this;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public StorageTaskCompletedEventData setTaskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    public String getSummaryReportBlobUrl() {
        return this.summaryReportBlobUrl;
    }

    public StorageTaskCompletedEventData setSummaryReportBlobUrl(String summaryReportBlobUrl) {
        this.summaryReportBlobUrl = summaryReportBlobUrl;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("completedDateTime", this.completedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.completedDateTime));
        jsonWriter.writeStringField("taskExecutionId", this.taskExecutionId);
        jsonWriter.writeStringField("taskName", this.taskName);
        jsonWriter.writeStringField("summaryReportBlobUrl", this.summaryReportBlobUrl);
        return jsonWriter.writeEndObject();
    }

    public static StorageTaskCompletedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (StorageTaskCompletedEventData)jsonReader.readObject(reader -> {
            StorageTaskCompletedEventData deserializedStorageTaskCompletedEventData = new StorageTaskCompletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedStorageTaskCompletedEventData.status = StorageTaskCompletedStatus.fromString(reader.getString());
                    continue;
                }
                if ("completedDateTime".equals(fieldName)) {
                    deserializedStorageTaskCompletedEventData.completedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("taskExecutionId".equals(fieldName)) {
                    deserializedStorageTaskCompletedEventData.taskExecutionId = reader.getString();
                    continue;
                }
                if ("taskName".equals(fieldName)) {
                    deserializedStorageTaskCompletedEventData.taskName = reader.getString();
                    continue;
                }
                if ("summaryReportBlobUrl".equals(fieldName)) {
                    deserializedStorageTaskCompletedEventData.summaryReportBlobUrl = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageTaskCompletedEventData;
        });
    }
}

